% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbBegin_PqConnection.R,
%   R/dbCommit_PqConnection.R, R/dbRollback_PqConnection.R, R/transactions.R
\name{postgres-transactions}
\alias{postgres-transactions}
\alias{dbBegin_PqConnection}
\alias{dbBegin,PqConnection-method}
\alias{dbCommit_PqConnection}
\alias{dbCommit,PqConnection-method}
\alias{dbRollback_PqConnection}
\alias{dbRollback,PqConnection-method}
\title{Transaction management.}
\usage{
\S4method{dbBegin}{PqConnection}(conn, ..., name = NULL)

\S4method{dbCommit}{PqConnection}(conn, ..., name = NULL)

\S4method{dbRollback}{PqConnection}(conn, ..., name = NULL)
}
\arguments{
\item{conn}{a \linkS4class{PqConnection} object, produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{...}{Unused, for extensibility.}

\item{name}{If provided, uses the \code{SAVEPOINT} SQL syntax
to establish, remove (commit) or undo a ßsavepoint.}
}
\value{
A boolean, indicating success or failure.
}
\description{
\code{dbBegin()} starts a transaction. \code{dbCommit()} and \code{dbRollback()}
end the transaction by either committing or rolling back the changes.
}
\examples{
\dontshow{if (postgresHasDefault()) withAutoprint(\{ # examplesIf}
library(DBI)
con <- dbConnect(RPostgres::Postgres())
dbWriteTable(con, "USarrests", datasets::USArrests, temporary = TRUE)
dbGetQuery(con, 'SELECT count(*) from "USarrests"')

dbBegin(con)
dbExecute(con, 'DELETE from "USarrests" WHERE "Murder" > 1')
dbGetQuery(con, 'SELECT count(*) from "USarrests"')
dbRollback(con)

# Rolling back changes leads to original count
dbGetQuery(con, 'SELECT count(*) from "USarrests"')

dbRemoveTable(con, "USarrests")
dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
