% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_rss_d.R
\name{scale_colour_rss_d}
\alias{scale_colour_rss_d}
\title{Plotting with RSS palettes for colour ggplot2}
\usage{
scale_colour_rss_d(palette, direction = 1, ...)
}
\arguments{
\item{palette}{Name of Palette. Run \code{names(RSSPalettes)} to view options.}

\item{direction}{Sets order of colors. Default direction is 1. If direction is -1,
palette color order is reversed}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{discrete_scale}}}
}
\value{
A ggproto object defining a discrete colour scale for use with ggplot2.
}
\description{
Plotting with RSS palettes for colour ggplot2
}
\examples{
library(ggplot2)
ggplot(data = mtcars, aes(x = mpg, y = disp, color = factor(cyl))) +
  geom_point() +
  scale_colour_rss_d(palette = "signif_qual")
}
