% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_crpsReSurvFit.R
\name{survival_crps.ReSurvFit}
\alias{survival_crps.ReSurvFit}
\title{Survival continuously ranked probability score.}
\usage{
\method{survival_crps}{ReSurvFit}(ReSurvFit, user_data_set = NULL)
}
\arguments{
\item{ReSurvFit}{ReSurvFit object to use for the score computation.}

\item{user_data_set}{data.frame provided from the user to compute the survival CRPS, optional.}
}
\value{
Survival CRPS, \code{data.table} that contains the CRPS (\code{crps}) for each observation (\code{id}).
}
\description{
Return the Survival Continuously Ranked Probability Score (SCRPS) of a \code{ReSurv} model.
}
\details{
The model fit uses the theoretical framework of Hiabu et al. (2023), that relies on the
}
\references{
Pittarello, G., Hiabu, M., & Villegas, A. M. (2023). Chain Ladder Plus: a versatile approach for claims reserving. arXiv preprint arXiv:2301.03858.

Therneau, T. M., & Lumley, T. (2015). Package ‘survival’. R Top Doc, 128(10), 28-33.

Katzman, J. L., Shaham, U., Cloninger, A., Bates, J., Jiang, T., & Kluger, Y. (2018). DeepSurv: personalized treatment recommender system using a Cox proportional hazards deep neural network. BMC medical research methodology, 18(1), 1-12.

Chen, T., He, T., Benesty, M., & Khotilovich, V. (2019). Package ‘xgboost’. R version, 90, 1-66.
}
