% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RprobitB_latent_classes.R
\name{RprobitB_latent_classes}
\alias{RprobitB_latent_classes}
\alias{print.RprobitB_latent_classes}
\title{Create object of class \code{RprobitB_latent_classes}}
\usage{
RprobitB_latent_classes(latent_classes = NULL)

\method{print}{RprobitB_latent_classes}(x, ...)
}
\arguments{
\item{latent_classes}{[\code{list()} | \code{NULL}]\cr
Optionally parameters specifying the number of latent classes and their
updating scheme. The values in brackets are the default.
\itemize{
\item \code{C} (\code{1}): The fixed number (greater or equal 1) of (initial) classes.
\item \code{wb_update} (\code{FALSE}): Set to \code{TRUE} for weight-based class updates.
\item \code{dp_update} (\code{FALSE}): Set to \code{TRUE} for Dirichlet process class updates.
\item \code{Cmax} (\code{10}): The maximum number of latent classes.
}

The following specifications are used for the weight-based updating scheme:
\itemize{
\item \code{buffer} (\code{50}): The number of iterations to wait before the next update.
\item \code{epsmin} (\code{0.01}): The threshold weight for removing a latent class.
\item \code{epsmax} (\code{0.7}): The threshold weight for splitting a latent class.
\item \code{deltamin} (\code{0.1}): The minimum mean distance before merging two classes.
\item \code{deltashift} (\code{0.5}): The scale for shifting the class means after a split.
}}

\item{x}{An object of class \code{RprobitB_latent_classes}.}

\item{...}{Currently not used.}
}
\value{
An object of class \code{RprobitB_latent_classes}.
}
\description{
This function creates an object of class \code{RprobitB_latent_classes} which
defines the number of latent classes and their updating scheme.
}
\keyword{internal}
