% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{update_Sigma}
\alias{update_Sigma}
\title{Update error covariance matrix}
\usage{
update_Sigma(n_Sigma_0, V_Sigma_0, N, S)
}
\arguments{
\item{n_Sigma_0}{[\code{integer(1)}]\cr
The degrees of freedom of the Inverse Wishart prior for \code{Sigma}.}

\item{V_Sigma_0}{[\code{matrix(J - 1, J - 1)}]\cr
The scale matrix of the Inverse Wishart prior for \code{Sigma}.}

\item{N}{[\code{integer(1)}]\cr
The sample size.}

\item{S}{[\code{matrix(J - 1, J - 1)}]\cr
The sum over the outer products of the residuals
\eqn{(\epsilon_n)_{n = 1, \dots, N}}.}
}
\value{
An update for \code{Sigma}.
}
\description{
Update error covariance matrix
}
\examples{
(Sigma_true <- matrix(c(1, 0.5, 0.2, 0.5, 1, 0.2, 0.2, 0.2, 2), ncol = 3))
beta <- matrix(c(-1, 1), ncol = 1)
N <- 100
X <- replicate(N, matrix(rnorm(6), ncol = 2), simplify = FALSE)
eps <- replicate(
  N, oeli::rmvnorm(n = 1, mean = c(0, 0, 0), Sigma = Sigma_true),
  simplify = FALSE
)
U <- mapply(function(X, eps) X \%*\% beta + eps, X, eps, SIMPLIFY = FALSE)
n_Sigma_0 <- 4
V_Sigma_0 <- diag(3)
outer_prod <- function(X, U) (U - X \%*\% beta) \%*\% t(U - X \%*\% beta)
S <- Reduce(`+`, mapply(
  function(X, U) (U - X \%*\% beta) \%*\% t(U - X \%*\% beta), X, U,
  SIMPLIFY = FALSE
))
Sigma_draws <- replicate(100, update_Sigma(n_Sigma_0, V_Sigma_0, N, S))
apply(Sigma_draws, 1:2, mean)

}
\keyword{gibbs_sampler}
