% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/troproj.poly.R
\name{tropproj.poly}
\alias{tropproj.poly}
\title{Projection on Tropical Polytope}
\usage{
tropproj.poly(x, tconv)
}
\arguments{
\item{x}{a data vector, of length e.}

\item{tconv}{a data matrix, of size e x s, with each column a vertex of the tropical polytope.
e is the dimension of the tropical space and s is the number of vertices of the polytope}
}
\value{
A projected vector on the given tropical polytope.
}
\description{
Project a point onto a given tropical polytope.
}
\examples{

# Generate a tropical polytope consisting of three trees each with 5 leaves
library(ape)
pltp <- sapply(1:3, function(i) {
  as.vector(rcoal(5))
})
# Generate an observation and vectorize it
tree <- rcoal(5)
tree_vec <- as.vector(tree)
tropproj.poly(tree_vec, pltp)
}
