% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_AlluvialPlot.R
\name{do_AlluvialPlot}
\alias{do_AlluvialPlot}
\title{Generate Alluvial plots.}
\usage{
do_AlluvialPlot(
  sample,
  first_group,
  last_group,
  middle_groups = NULL,
  colors.use = NULL,
  colorblind = FALSE,
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  font.size = 14,
  font.type = "sans",
  xlab = NULL,
  ylab = "Number of cells",
  repel = FALSE,
  fill.by = last_group,
  use_labels = FALSE,
  stratum.color = "black",
  stratum.fill = "white",
  stratum.width = 1/3,
  stratum.fill.conditional = FALSE,
  use_geom_flow = FALSE,
  alluvium.color = "white",
  flow.color = "white",
  flip = FALSE,
  label.color = "black",
  curve_type = "sigmoid",
  use_viridis = FALSE,
  viridis.palette = "G",
  viridis.direction = -1,
  sequential.palette = "YlGnBu",
  sequential.direction = 1,
  plot.grid = FALSE,
  grid.color = "grey75",
  grid.type = "dashed",
  na.value = "white",
  legend.position = "bottom",
  legend.title = NULL,
  plot.title.face = "bold",
  plot.subtitle.face = "plain",
  plot.caption.face = "italic",
  axis.title.face = "bold",
  axis.text.face = "plain",
  legend.title.face = "bold",
  legend.text.face = "plain"
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{first_group}{\strong{\code{\link[base]{character}}} | Categorical metadata variable. First group of nodes of the alluvial plot.}

\item{last_group}{\strong{\code{\link[base]{character}}} | Categorical metadata variable. Last group of nodes of the alluvial plot.}

\item{middle_groups}{\strong{\code{\link[base]{character}}} | Categorical metadata variable. Vector of groups of nodes of the alluvial plot.}

\item{colors.use}{\strong{\code{\link[base]{character}}} | Named list of colors corresponding to the unique values in fill.by (which defaults to last_group).}

\item{colorblind}{\strong{\code{\link[base]{logical}}} | Whether to use colorblind-friendly colors for categorical variables. In place when \code{colors.use} is not used. Allows for a maximum of 85 different classes within a categorical variable.}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{xlab, ylab}{\strong{\code{\link[base]{character}}} | Titles for the X and Y axis.}

\item{repel}{\strong{\code{\link[base]{logical}}} | Whether to repel the text labels.}

\item{fill.by}{\strong{\code{\link[base]{character}}} | One of first_group, middle_groups (one of the values, if multiple mid_groups) or last_group. These values will be used to color the alluvium/flow.}

\item{use_labels}{\strong{\code{\link[base]{logical}}} | Whether to use labels instead of text for the stratum.}

\item{stratum.color, alluvium.color, flow.color}{\strong{\code{\link[base]{character}}} | Color for the border of the alluvium (and flow) and stratum.}

\item{stratum.fill}{\strong{\code{\link[base]{character}}} | Color to fill the stratum.}

\item{stratum.width}{\strong{\code{\link[base]{logical}}} | Width of the stratum.}

\item{stratum.fill.conditional}{\strong{\code{\link[base]{logical}}} | Whether to fill the stratum with the same colors as the alluvium/flow.}

\item{use_geom_flow}{\strong{\code{\link[base]{logical}}} | Whether to use \code{\link[ggalluvial]{geom_flow}} instead of \code{\link[ggalluvial]{geom_alluvium}}. Visual results might differ.}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{label.color}{\strong{\code{\link[base]{character}}} | Color for the text labels.}

\item{curve_type}{\strong{\code{\link[base]{character}}} | Type of curve used in \code{\link[ggalluvial]{geom_alluvium}}. One of:
\itemize{
\item \emph{\code{linear}}.
\item \emph{\code{cubic}}.
\item \emph{\code{quintic}}.
\item \emph{\code{sine}}.
\item \emph{\code{arctangent}}.
\item \emph{\code{sigmoid}}.
\item \emph{\code{xspline}}.
}}

\item{use_viridis}{\strong{\code{\link[base]{logical}}} | Whether to use viridis color scales.}

\item{viridis.palette}{\strong{\code{\link[base]{character}}} | A capital letter from A to H or the scale name as in \link[viridis]{scale_fill_viridis}.}

\item{viridis.direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Controls how the gradient of viridis scale is formed.}

\item{sequential.palette}{\strong{\code{\link[base]{character}}} | Type of sequential color palette to use. Out of the sequential palettes defined in \strong{\code{\link[RColorBrewer]{brewer.pal}}}.}

\item{sequential.direction}{\strong{\code{\link[base]{numeric}}} | Direction of the sequential color scale. Either 1 or -1.}

\item{plot.grid}{\strong{\code{\link[base]{logical}}} | Whether to plot grid lines.}

\item{grid.color}{\strong{\code{\link[base]{character}}} | Color of the grid in the plot. In heatmaps, color of the border of the cells.}

\item{grid.type}{\strong{\code{\link[base]{character}}} | One of the possible linetype options:
\itemize{
\item \emph{\code{blank}}.
\item \emph{\code{solid}}.
\item \emph{\code{dashed}}.
\item \emph{\code{dotted}}.
\item \emph{\code{dotdash}}.
\item \emph{\code{longdash}}.
\item \emph{\code{twodash}}.
}}

\item{na.value}{\strong{\code{\link[base]{character}}} | Color value for NA.}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{plot.title.face, plot.subtitle.face, plot.caption.face, axis.title.face, axis.text.face, legend.title.face, legend.text.face}{\strong{\code{\link[base]{character}}} | Controls the style of the font for the corresponding theme element.  One of:
\itemize{
\item \emph{\code{plain}}: For normal text.
\item \emph{\code{italic}}: For text in itallic.
\item \emph{\code{bold}}: For text in bold.
\item \emph{\code{bold.italic}}: For text both in itallic and bold.
}}
}
\value{
A ggplot2 object.
}
\description{
This function is based on the \pkg{ggalluvial} package. It allows you to generate alluvial plots from a given Seurat object.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_AlluvialPlot", passive = TRUE)
  message(value)
  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Compute basic sankey plot.
    p <- SCpubr::do_AlluvialPlot(sample = sample,
                                 first_group = "orig.ident",
                                 last_group = "seurat_clusters")

  } else if (base::isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
