% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dupfilter_exact.R
\name{dupfilter_exact}
\alias{dupfilter_exact}
\title{Filter temporally and spatially exact duplicates}
\usage{
dupfilter_exact(sdata)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
See the data \code{\link{turtle}} for an example.
The function filters the input data by a unique "id" (e.g. transmitter number, identifier for each animal). 
"DateTime" is the GMT date & time of each location in class \code{\link[base:DateTimeClasses]{POSIXct}} or \code{\link[base]{character}} with the following format "2012-06-03 01:33:46".
"lat" and "lon" are the latitude and longitude of each location in decimal degrees. 
"qi" is the quality index associated with each location fix. 
The input values can be either the number of GPS satellites or Argos Location Classes. 
Argos Location Classes will be converted to numerical values, where "A", "B", "Z" will be replaced with "-1", "-2", "-3" respectively.
The greater number indicates a higher accuracy.}
}
\value{
The input data frame is returned with temporally and spatially exact duplicates removed.
}
\description{
Function to filter temporally and spatially exact locations in tracking data.
}
\details{
This is a partial component of \code{\link{dupfilter}}, although works as a stand-alone function.
It looks for temporally and spatially exact locations and retains only a single fix (latitude/longitude pair) per time and location.
}
\references{
Shimada T, Limpus C, Jones R, Hazel J, Groom R, Hamann M (2016) 
Sea turtles return home after intentional displacement from coastal foraging areas. 
\emph{Marine Biology} 163:1-14 \doi{10.1007/s00227-015-2771-0}
}
\seealso{
\code{\link{dupfilter}}, \code{\link{dupfilter_qi}}, \code{\link{dupfilter_time}}, \code{\link{dupfilter_space}}
}
\author{
Takahiro Shimada
}
