% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parameters_Selection.R
\name{BIC_PFP}
\alias{BIC_PFP}
\title{Selecting Tuning Parameter for Factor Adjusted-Pairwise Fusion Penalty (FA-PFP) Method via corresponding BIC}
\usage{
BIC_PFP(
  Y,
  Fhat,
  Uhat,
  alpha_init,
  lasso_start,
  lasso_stop,
  lam_start,
  lam_stop,
  grid_1,
  grid_2,
  epsilon
)
}
\arguments{
\item{Y}{The response vector of length \eqn{n}.}

\item{Fhat}{The estimated common factors matrix of size \eqn{n \times r}.}

\item{Uhat}{The estimated idiosyncratic factors matrix of size \eqn{n \times p}.}

\item{alpha_init}{The initialization of intercept parameter.}

\item{lasso_start}{The user-supplied start search value of the tuning parameters for LASSO.}

\item{lasso_stop}{The user-supplied stop search value of the tuning parameters for LASSO.}

\item{lam_start}{The user-supplied start search value of the tuning parameters for Pairwise Fusion Penalty.}

\item{lam_stop}{The user-supplied stop search value of the tuning parameters for Pairwise Fusion Penalty.}

\item{grid_1}{The user-supplied number of search grid points corresponding to the LASSO tuning parameter.}

\item{grid_2}{The user-supplied number of search grid points corresponding to the tuning parameter for Pairwise Fusion Penalty.}

\item{epsilon}{The user-supplied stopping tolerance.}
}
\value{
A list with the following components:
\item{lasso}{The tuning parameter of the LASSO penalty selected using BIC.}
\item{lambda}{The tuning parameter of the Pairwise Concave Fusion Penalty selected using BIC.}
}
\description{
This function is to select tuning parameters simultaneously for FA-PFP method via minimizing the BIC.
}
\examples{
n <- 50
p <- 50
r <- 3
lasso_start <- sqrt(log(p)/n)*0.1
lasso_stop <- sqrt(log(p)/n)
lam_start <- 0.3
lam_stop <- 1
grid_1 <- 5
grid_2 <- 5
alpha <- sample(c(-3,3),n,replace=TRUE,prob=c(1/2,1/2))
beta <- c(rep(1,2),rep(0,48))
B <- matrix((rnorm(p*r,1,1)),p,r)
F_1 <- matrix((rnorm(n*r,0,1)),n,r)
U <- matrix(rnorm(p*n,0,0.1),n,p)
X <- F_1\%*\%t(B)+U
Y <- alpha + X\%*\%beta + rnorm(n,0,0.5)
alpha_init <- INIT(Y,F_1,0.1)
\donttest{
BIC_PFP(Y,F_1,U,alpha_init,lasso_start,lasso_stop,lam_start,lam_stop,grid_1,grid_2,0.3)
}
}
\author{
Yong He, Liu Dong, Fuxin Wang, Mingjuan Zhang, Wenxin Zhou.
}
