% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRAPM.R
\name{print.SeaSondeRAPM}
\alias{print.SeaSondeRAPM}
\title{Print a SeaSondeRAPM Object}
\usage{
\method{print}{SeaSondeRAPM}(x, ...)
}
\arguments{
\item{x}{A SeaSondeRAPM object. This object should be created using the
seasonder_createSeaSondeRAPM() function and must include a calibration matrix,
a quality matrix, the BEAR attribute, and a StationCode.}

\item{...}{Additional arguments that might be passed to other methods; currently not used.}
}
\value{
The SeaSondeRAPM object itself, invisibly.
}
\description{
This function prints the details of a SeaSondeRAPM object, including the station code,
original file name, site origin (latitude and longitude), and antenna bearing.
It is primarily used for displaying the object's metadata in a human-readable format.
}
\examples{
# Print metadata of a test SeaSondeRAPM object
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
obj <- seasonder_readSeaSondeRAPMFile(apm_file)
print(obj)
}
