% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICInitDOASolutions}
\alias{seasonder_MUSICInitDOASolutions}
\title{Initialize Direction of Arrival (DOA) Solutions for MUSIC Algorithm}
\usage{
seasonder_MUSICInitDOASolutions()
}
\value{
A list with initialized placeholders for \code{"single"} and \code{"dual"} DOA solutions.
}
\description{
This function initializes the data structure for storing Direction of Arrival (DOA) solutions
calculated by the MUSIC algorithm.
}
\details{
The function returns a list containing two sub-lists, one for \code{"single"} solutions and another for \code{"dual"} solutions:
\itemize{
\item \code{"single"}: Contains placeholders for single DOA solutions:
\itemize{
\item \code{bearing}: The bearing angle (\code{NA_real_} by default).
\item \code{a}: The complex steering vector (\code{NA_complex_} by default).
\item \code{P}: The power spectrum value (\code{NA_complex_} by default).
}
\item \code{"dual"}: Contains placeholders for dual DOA solutions:
\itemize{
\item \code{bearing}: The bearing angle (\code{NA_real_} by default).
\item \code{a}: The complex steering vector (\code{NA_complex_} by default).
\item \code{P}: A 2 x 2 complex matrix initialized to \code{NA_complex_}.
}
}
}
\seealso{
\code{\link{seasonder_MUSICInitCov}} for initializing covariance matrices.
\code{\link{seasonder_MUSICInitProjections}} for initializing projection matrices.
}
