% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_getFOR_parameters}
\alias{seasonder_getFOR_parameters}
\title{Retrieve First Order Region (FOR) Parameters}
\usage{
seasonder_getFOR_parameters(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing FOR-related metadata.}
}
\value{
A named list containing the validated FOR parameters.
}
\description{
This function retrieves the First Order Region (FOR) parameters associated with a
SeaSondeR cross-spectral object. If no FOR parameters are found in the object's
attributes, it initializes them using \code{\link{seasonder_validateFOR_parameters}}.
}
\details{
The function extracts the FOR parameters stored within the object. If the parameters
are missing, the function initializes them using \code{\link{seasonder_validateFOR_parameters}}
and assigns default values where necessary.

\strong{FOR Parameters:}
\itemize{
\item \strong{nsm}: Doppler smoothing factor.
\item \strong{fdown}: Peak power dropoff threshold.
\item \strong{flim}: Null below peak power threshold.
\item \strong{noisefact}: Signal-to-noise threshold.
\item \strong{currmax}: Maximum velocity allowed.
\item \strong{reject_distant_bragg}: Flag to reject distant Bragg signals.
\item \strong{reject_noise_ionospheric}: Flag to reject ionospheric noise contamination.
\item \strong{reject_noise_ionospheric_threshold}: Threshold (in dB) for rejecting noise-affected Bragg signals.
\item \strong{reference_noise_normalized_limits}: Estimated limits for reference noise in normalized Doppler frequency.
}
}
\seealso{
\code{\link{seasonder_validateFOR_parameters}} for initializing and validating FOR parameters.
\code{\link{seasonder_defaultFOR_parameters}} for retrieving default parameter values.
}
