% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{ggplot_dt}
\alias{ggplot_dt}
\title{plotting function for spatial data}
\usage{
ggplot_dt(
  dt,
  data_col = NULL,
  mn = NULL,
  discrete_cs = FALSE,
  rr = NULL,
  low = NULL,
  mid = NULL,
  high = NULL,
  name = data_col,
  midpoint = NULL,
  breaks = NULL,
  na.value = "gray75",
  oob = NULL,
  guide = guide_colorbar(barwidth = 0.5, barheight = 10),
  ...,
  binwidth = NULL,
  bin_midpoint = midpoint,
  add_map = TRUE,
  extent = NULL,
  expand.x = c(0, 0),
  expand.y = c(0, 0),
  dimension_check = TRUE
)
}
\arguments{
\item{dt}{Data table containing the data for plotting.}

\item{data_col}{The name of the column in dt containing the data for plotting. If nothing is provided (the default), the first column that is not a dimension variable or 'member' is selected.}

\item{mn}{optional plot title}

\item{discrete_cs}{Logical. Should the color scale be discretized?}

\item{rr, low, mid, high, name, breaks, na.value, oob, guide, ...}{Arguments for the color scale, passed to scale_fill_gradient2 or scale_fill_steps2 (depending on whether discrete_cs == TRUE).
rr replaces limits (specifying the range of the color scale) for consistency with the older plotting functions from the PostProcessing package.
\code{na.value} specifies the color of missing values. \code{oob} specifies the treatment of out-of-boundary values, i.e. values beyond the
limits.
The ... argument can in particular be used to customize the legend/colorbar using the function \code{guide_colorbar},
see https://ggplot2.tidyverse.org/reference/guide_colourbar.html. Moreover, when \code{discrete_cs == TRUE} you can pass the arguments \code{n.breaks,breaks} to customize the scale.
If you use n.breaks you might also want to set nice.breaks = FALSE, see ?scale_fill_steps2.}

\item{midpoint}{midpoint of the color scale, passed to \code{scale_fill_gradient2} or \code{scale_fill_steps2} (depending on whether \code{discrete_cs == TRUE}).
If you set it to NULL (the default), the midpoint is set to the center of the data range (or the center of rr, if provided), such that the entire color scale is used.
Note that this default differs from the default behavior of \code{scale_fill_gradient2} or \code{scale_fill_steps2}.
Specifying the midpoint can often be a convenient way to force a color scale with only two colors (for example, by setting it
to the minimum or maximum of your data).}

\item{binwidth, bin_midpoint}{only used when \code{discrete_cs == TRUE}. Normally, the breaks for the discrete colorscale are specified by n.breaks (which is not reliable,
since they're adjusted to be 'nice'), or by specifying the breaks explicitly (which is often tedious). This gives you a third option, namely specifying how far the breaks
should be apart, and specifying the centerpoint for one of the bins (default is midpoint, or the center of rr if midpoint is not provided). For example, if your color scale shows
percentages and you'd like 4 categories, ranging from white to red, this is easiest achieved by \code{binwidth = 25, midpoint = 12.5}.}

\item{add_map}{logical, defaults to \code{TRUE}, mostly for internal use. Set to \code{FALSE} to remove borders (e.g. if you want to add them yourself from a shapefile).}

\item{extent}{An optional four-element vector in the order xmin,xmax,ymin,ymax for specifying the spatial extent of the plot. Default is to fit the extent to the data.}

\item{expand.x, expand.y}{vectors with two entries to be added to xlims/ylims of the plot. E.g. expand.x = c(-0.5,0.5)
expands the plot by half a longitude both on the right and left hand side}

\item{dimension_check}{Logical. By default the function checks that there are not multiple values per coordinate
(and subsets to the first level if there are several, e.g. to the first year and month (by appearance in \code{dt}) if \code{dt} contains data for several years and months).}
}
\value{
a ggplot object.
}
\description{
Plots spatial data from a data.table. The data table needs to contain columns named 'lon' and 'lat'. The grid needs to be regular.
If spatial data is contained for several levels (e.g. mutliple times or multiple ensemble members), only the data for the first level is plotted.
By default, the first column that is not recognized as a dimension variable is plotted, see \code{data_col}. For the most common data-columns, reasonable
color scales are selected automatically.
}
\examples{
ex_dt = chirps_monthly[lat <0 & month == 12 & year == 2020]
pp = ggplot_dt(ex_dt)
if(interactive()) plot(pp)

}
\author{
Claudio Heinrich
}
