% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seeds.R
\name{seed_maker}
\alias{seed_maker}
\title{Construct a list containing a collection of seeds}
\usage{
seed_maker(
  seed,
  level_names,
  n_per_level,
  sample_vector = rep(list(rlang::expr(1:1e+06)), length(level_names)),
  index_level = rep(TRUE, length(level_names)),
  flatten = FALSE
)
}
\arguments{
\item{seed}{A number, interpreted as an integer, or NULL (see
\code{\link[base:Random]{set.seed()}}).}

\item{level_names}{A character vector, or list of character vectors,
indicating the element name(s) to use for each level of the returned list.}

\item{n_per_level}{An integer vector indicating the number of elements to
produce at each level of the returned list.}

\item{sample_vector}{A list of expressions that are evaluable as integer
vectors indicating the values from which to sample (without replacement) at
each level of the returned list.}

\item{index_level}{A logical vector indicating whether to index the root name
of a respective level.}

\item{flatten}{"Flatten" the lowest level of the returned list into a named
vector?}
}
\value{
When \code{flatten} is set to FALSE, a hierarchical list with
\code{length(level_names)} levels containing a collection of seeds.

When \code{flatten} is set to TRUE, a hierarchical list with
\code{length(level_names)} - 1 level(s) containing a collection of seeds (where
"0 levels" corresponds to a named integer vector - see \strong{Details}).
}
\description{
\code{seed_maker()} constructs a hierarchical list containing a collection of
seeds from a single seed.
}
\details{
\code{length(level_names)} must be equal to \code{length(n_per_level)} must be equal
equal to \code{length(sample_vector)} must be equal to \code{length(index_level)}.
When these arguments are greater than length 1, the intermediate seeds used
to produce the seeds at the lowest level of the returned list are not
included therein. In other words, only the collection of seeds at the
lowest list level are returned.

If \code{level_names} is a character vector, each of its elements is used as the
root name for the list elements produced at the respective level. See
\code{seeds_list1} and \code{seeds_list2} in \strong{Examples}.

If \code{level_names} is a list of character vectors:
\itemize{
\item The element contained in a length 1 vector is used as the root name for
the list elements produced at the respective level.
\item Elements contained in a vector that is greater than length 1 are used
verbatim as the names for the list elements produced at the respective
level. The corresponding value of \code{n_per_level} must match the length of
the vector.
}

See \code{seeds_list3}, \code{seeds_list4}, and \code{seeds_list5} in \strong{Examples}.

For each element, i, of \code{sample_vector}:
\itemize{
\item \code{length(eval(sample_vector[[i]]))} must be >= \code{n_per_level[i]}.
\item The values of \code{eval(sample_vector[[i]])} must be unique, positive
integers.
}

See \code{seeds_list6}, \code{seeds_list7}, and \code{seeds_list8} in \strong{Examples}.

Element name indexing applies to root name-provided levels only. Thus, for
each element, i, of \code{index_level}, if \code{length(level_names[[i]])} is greater
than 1, the value of \code{index_level[i]} is ignored. Otherwise:
\itemize{
\item When \code{index_level[i]} is TRUE, the element names at the respective level
are indexed from 1 - \code{n_per_level[i]}.
\item When \code{index_level[i]} is FALSE, the element name at the respective level
is used verbatim, so long as \code{n_per_level[i]} = 1, since suppressing
element name indexing makes sense only for single-element levels.
}

See \code{seeds_list9}, \code{seeds_list10}, \code{seeds_list11}, \code{seeds_list12}, and
\code{seeds_list13} in \strong{Examples}.

When \code{flatten} is set to TRUE, each set of seeds at the lowest level of the
returned list is converted into a named vector (versus remaining in the
default structure, which is a list of single value elements). When only a
single level is specified (via \code{level_names}, \code{n_per_level},
\code{sample_vector}, and \code{index_level} all being length 1), a named integer
vector is returned instead of a list. See \code{seeds_flat1}, \code{seeds_flat2},
\code{seeds_flat5}, \code{seeds_flat9}, \code{seeds_flat10}, and \code{seeds_flat11} in
\strong{Examples}.
}
\examples{
seeds_list1 <- seed_maker(
  seed = 1234,
  level_names = c("sim"),
  n_per_level = c(10)
)

seeds_list2 <- seed_maker(
  seed = 1234,
  level_names = c("sim", "dataset"),
  n_per_level = c(10, 15)
)

seeds_list3 <- seed_maker(
  seed = 1234,
  level_names = list("sim", c("component_a", "component_b", "component_c")),
  n_per_level = c(10, 3)
)

try(seeds_list4 <- seed_maker(
  seed = 1234,
  level_names = list("sim", c("component_a", "component_b", "component_c")),
  n_per_level = c(10, 4)
))

seeds_list5 <- seed_maker(
  seed = 1234,
  level_names = list(
    "sim",
    c("component_a", "component_b", "component_c"),
    "dataset"
  ),
  n_per_level = c(10, 3, 5)
)

seeds_list6 <- seed_maker(
  seed = 1234,
  level_names = c("sim"),
  n_per_level = c(10),
  sample_vector = list(1:100)
)

seeds_list7 <- seed_maker(
  seed = 1234,
  level_names = c("sim", "dataset"),
  n_per_level = c(10, 15),
  sample_vector = list(1:100, 1:1000)
)

seeds_list8 <- seed_maker(
  seed = 1234,
  level_names = list(
    "sim",
    c("component_a", "component_b", "component_c"),
    "dataset"
  ),
  n_per_level = c(10, 3, 5),
  sample_vector = list(1:100, 1:1000, 1:10000)
)

seeds_list9 <- seed_maker(
  seed = 1234,
  level_names = c("sim"),
  n_per_level = c(1)
)

try(seeds_list10 <- seed_maker(
  seed = 1234,
  level_names = c("sim"),
  n_per_level = c(10),
  index_level = FALSE
))

seeds_list11 <- seed_maker(
  seed = 1234,
  level_names = c("sim"),
  n_per_level = c(1),
  index_level = FALSE
)

seeds_list12 <- seed_maker(
  seed = 1234,
  level_names = list("sim", c("component_a", "component_b", "component_c")),
  n_per_level = c(1, 3),
  index_level = c(FALSE, TRUE)
)

seeds_list13 <- seed_maker(
  seed = 1234,
  level_names = list("sim", c("component_a", "component_b", "component_c")),
  n_per_level = c(1, 3),
  index_level = c(FALSE, FALSE)
)

identical(seeds_list12, seeds_list13)

seeds_flat1 <- seed_maker(
  seed = 1234,
  level_names = c("sim"),
  n_per_level = c(10),
  flatten = TRUE
)

is.list(seeds_flat1)
is.integer(seeds_flat1)

seeds_flat2 <- seed_maker(
  seed = 1234,
  level_names = c("sim", "dataset"),
  n_per_level = c(10, 15),
  flatten = TRUE
)

is.list(seeds_flat2$sim1)
is.integer(seeds_flat2$sim1)

seeds_flat5 <- seed_maker(
  seed = 1234,
  level_names = list(
    "sim",
    c("component_a", "component_b", "component_c"),
    "dataset"
  ),
  n_per_level = c(10, 3, 5),
  flatten = TRUE
)

is.list(seeds_flat5$sim1$component_a)
is.integer(seeds_flat5$sim1$component_a)

seeds_flat9 <- seed_maker(
  seed = 1234,
  level_names = c("sim"),
  n_per_level = c(1),
  flatten = TRUE
)

is.list(seeds_flat9)
is.integer(seeds_flat9)

try(seeds_flat10 <- seed_maker(
  seed = 1234,
  level_names = c("sim"),
  n_per_level = c(10),
  index_level = FALSE,
  flatten = TRUE
))

seeds_flat11 <- seed_maker(
  seed = 1234,
  level_names = c("sim"),
  n_per_level = c(1),
  index_level = FALSE,
  flatten = TRUE
)

is.list(seeds_flat11)
is.integer(seeds_flat11)
}
