% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACO_MPlus.R
\name{antcolony.mplus}
\alias{antcolony.mplus}
\title{A function to implement the ant colony optimization algorithm for short form
specification searches, either using MPlus directly via
\code{\link[base]{system}} calls or using Mplus indirectly with the package
\link[MplusAutomation]{MplusAutomation}.}
\usage{
antcolony.mplus(
  ants = 20,
  evaporation = 0.95,
  mplus = NULL,
  list.items = NULL,
  full = NULL,
  i.per.f = NULL,
  factors = NULL,
  steps = 50,
  max.run = 1000,
  resultfile = NULL,
  summaryfile = "summary.txt",
  min.CFI = 0.95,
  min.TLI = 0.95,
  max.RMSEA = 0.06,
  feedbackfile = "iteration.html",
  loc.gammas,
  loc.variances,
  predictors,
  var.predictors,
  Mplus.Automation = FALSE,
  dataOut = "tempModel.dat",
  modelOut = "tempModel.inp"
)
}
\arguments{
\item{ants}{A numeric value indicating the number of ants to send send (short
forms to evaluate) per iteration. Default value is 20.}

\item{evaporation}{A numeric value which sets the percentage of the pheremone
that is retained after evaporation between steps of the algorithm. Default
value is 0.9, indicating 10% evaporation. Should be within the range of
(0,1), exclusive.}

\item{mplus}{When \code{Mplus.Automation=FALSE}, this is a character value
indicating the name of the MPlus input file without the file extension
".inp". If not in the current working directory, include the full file path
where it is located. This file will be changed during the ant colony search,
so it's suggested to make a backup of the original file before running the
function. When \code{Mplus.Automation=TRUE}, this is an object of class
\link[MplusAutomation]{mplusObject} created by
\link[MplusAutomation]{MplusAutomation} and containing the initial model.}

\item{list.items}{A list containing one or more character vectors of item
names for each factor, where each factor is a separate element of the list.
The items should be input in the order in which the factors are input in
\code{i.per.f} and \code{factors}.}

\item{full}{A numeric value indicating the total number of unique items in the
test or scale.}

\item{i.per.f}{A vector with number of items per factor (e.g. target number),
in the same order of \code{list.items} and \code{factors}.}

\item{factors}{A character vector with the names of the factors in the same
order of \code{list.items} and \code{i.per.f}.}

\item{steps}{A numeric value that sets the stopping rule, which is the number
of ants in a row for which the model does not change.}

\item{max.run}{The maximum number of ants to run before the algorithm stops.
This includes failed iterations as well. Default is 1000.}

\item{resultfile}{A character vector containing the file path where the MPlus
results for the current ant model is saved. If the file is not in the
current working directery, the full path must be specified. Not used when
\code{Mplus.Automation=FALSE}.}

\item{summaryfile}{A character vector containing the name of the summary file
generated. A .txt file is suggested. Default is "summary.txt" and writes
into the current working directory. This file writes a line for each ant
within each step and includes (a) a vector of a 0/1 value for each item
indicating whether the item was selected by that ant, (b) the run number,
(c) the count number, (d) the ant number, and (e) the current pheromone
level.}

\item{min.CFI}{A numeric value indicating the minimum CFI for "acceptable"
model fit. Models with CFI less than this value are automatically rejected.
Default is 0.95.}

\item{min.TLI}{A numeric value indicating the minimum TLI for "acceptable"
model fit. Models with TLI less than this value are automatically rejected.
Default is 0.95.}

\item{max.RMSEA}{A numeric value indicating the maximum RMSEA for "acceptable"
model fit. Models with RMSEA greater than this value are automatically
rejected. Default is 0.06}

\item{feedbackfile}{A character vector containing the name of the feedback
file generated. An .html file is suggested. Default is "iteration.html" and
writes into the current working directory. This file saves the result of
each run, which includes (a) the run number, (b) the count number, (c) the
ant number, (d) the step number (if the current run is successful) or
"Failure" (if the current run is unsuccessful), and for successful runs (f)
the value of CFI, TLI, and RMSEA fit indices, the average of the gammas
(standardized regression coefficients), and the overall variance explained
of the current run.}

\item{loc.gammas}{A numeric vector with the line numbers where the regression
coefficients of the MIMIC model start and end (locations). Not used with
\code{Mplus.Automation=TRUE}}

\item{loc.variances}{A numeric vector with the line numbers of the residual
variances of the latent factors. Not used with \code{Mplus.Automation=TRUE}}

\item{predictors}{Character vector with names of predictor variables, if any.}

\item{var.predictors}{A numeric vector with variances of the predictor(s), if
any. Not used with \code{Mplus.Automation=TRUE}}

\item{Mplus.Automation}{Logical. If \code{TRUE}, uses the
\code{MplusAutomation} package to modify the model as the algorithm
procedes. The "mplus" option will then be used as Defaults to \code{FALSE}
as it is in the process of being built.}

\item{dataOut}{A character vector specifying the location and name of the data
file generated by \code{MplusAutomation} for each iteration of the
algorithm. Default is "tempData.dat" and saves to the current working
directory. When specifying the name, be sure to use a data format that Mplus
can read. You must change the working directory to the location in which
this file will be saved. Only used when \code{Mplus.Automation=TRUE}.}

\item{modelOut}{A character vector specifying the location and name of the
Mplus model file generated by \code{MplusAutomation} for each iteration of
the algorithm. Default is "tempModel.inp" and saves to the current working
directory. When specifying the name of the model file, it must be a ".inp"
extension. You must change the working directory to the location in which
this file will be saved. Only used when \code{Mplus.Automation=TRUE}.}
}
\value{
A named matrix containing final model's best RMSEA, CFI, and TLI
 values, the final pheromone level (the mean of the standardized regression
 coefficients (gammas)), and a series of 0/1 values indicating the items
 selected in the final solution.
}
\description{
The Ant Colony Optimization (ACO) algorithm (Dorigo & Stutzle,
2004) can produce short forms of scales that are optimized with respect to
characteristics selected by the developer, such as model fit and predictive
relationships with other variables. The algorithm is based on the foraging
behavior of a group of ants, which start searching for food in a variety of
directions and then eventually all ants converge to the shortest distance to
the food source. This behavior occurs because ants leave a pheromone trail
behind as they search for food and ants in shorter paths leave stronger
pheromone trails, which are detected by other ants and that will lead them to
follow the shortest trail.
}
\details{
This function sends a specified number of ants
per iteration, which randomly select items to build a model, then evaluates
the model based on pheromone levels. The pheromone levels are updated after
each iteration according to the best-fitting model of that iteration. The
algorithm's stopping rule is to end the search when a certain solution is the
same for a given number of ants in a row. When constructing the mplus dataset
and when \code{Mplus.Automation=FALSE}, make sure that items in 'categorical
are' and 'usevariables' are specifications that take the same number of lines
per short form.

PREPARATORY STEPS: For the ACO algorithm implementation for short
for selection, the following decisions are needed:

1. Determine the target size for the short form.

2. Determine which characteristics should be optimized.

3. Define how the pheromone level will be computed: This is a function of the
characteristics of the short form that will be optimized. In Leite, Huang and
Marcoulides (2008), the pheromone level was zero if model fit indices did
not meet Hu and Bentler's (1999) suggested thresholds, and equal to the sum of
path coefficients of a predictor variable if model fit indices met thresholds.
Currently, the package only implements pheromone calculation based on
regression coefficients or variance explained, with user-selected model fit
index thresholds.

4. Define how many short forms should be evaluated before the best-so-far
pheromone level is examined. Leite, Huang and Marcoulides (2008) used 10 short
forms.

5. Define the percentage of pheromone evaporation, if any. Leite, Huang and
Marcoulides (2008) used 5\%.

6. Define convergence criterion. Leite, Huang and Marcoulides (2008) set the
algorithm to converge if the short form did not improve in 100 x number of
short forms in step 4.

IMPLEMENTATION: Once these decisions are made, the ACO algorithm
selects short forms with the following steps:

Step 1. All items are assigned an initial weight of 1.

Step 2. A set of n short forms is selected by sampling with probability
proportional to the items' weights.

Step 3. Fit latent variable model to the n short forms.

Step 4. Calculate the pheromone levels for the n short forms. Define the
best-so-far pheromone level (if iteration 1) or compare the current best
pheromone from the set of n short forms to the best-so-far pheromone.

Step 5. If the pheromone level of the best short form from step 4 exceeds the
best-so-far pheromone level, update the best-so-far pheromone level and add it
to the current weight of the items of the best short form.

Step 6. Return to step 2 until convergence criterion is reached.
}
\examples{
\dontrun{
# use MplusAutomation to find a 15-item short form of a simulated 56-item unidimensional test
# first, create the list of the items by the factors
# in this case, all items load onto the general 'Ability' factor
list.items <- list(c(
  "Item1", "Item2", "Item3", "Item4", "Item5",
  "Item6", "Item7", "Item8", "Item9", "Item10",
  "Item11", "Item12", "Item13", "Item14", "Item15",
  "Item16", "Item17", "Item18", "Item19", "Item20",
  "Item21", "Item22", "Item23", "Item24", "Item25",
  "Item26", "Item27", "Item28", "Item29", "Item30",
  "Item31", "Item32", "Item33", "Item34", "Item35",
  "Item36", "Item37", "Item38", "Item39", "Item40",
  "Item41", "Item42", "Item43", "Item44", "Item45",
  "Item46", "Item47", "Item48", "Item49", "Item50",
  "Item51", "Item52", "Item53", "Item54", "Item55",
  "Item56"
))
# then, load the data
data(simulated_test_data)

# Create the mplusObject with MplusAutomation
# notice the explicit call of each item, instead of the shorthand "Item1-Item56"
initial.MplusAutomation.model <- MplusAutomation::mplusObject(
  TITLE = "Trial ACO MpluAutomation with FERA 2016 Data;",
  MODEL = "Ability BY Item1 Item2 Item3 Item4 Item5
  Item6 Item7 Item8 Item9 Item10 Item11 Item12
  Item13 Item14 Item15 Item16 Item17 Item18
  Item19 Item20 Item21 Item22 Item23 Item24
  Item25 Item26 Item27 Item28 Item29 Item30
  Item31 Item32 Item33 Item34 Item35 Item36
  Item37 Item38 Item39 Item40 Item41 Item42
  Item43 Item44 Item45 Item46 Item47 Item48
  Item49 Item50 Item51 Item52 Item53 Item54
  Item55 Item56;",
  ANALYSIS = "ESTIMATOR = WLSMV;",
  VARIABLE = "CATEGORICAL = Item1 Item2 Item3 Item4 Item5
  Item6 Item7 Item8 Item9 Item10 Item11 Item12
  Item13 Item14 Item15 Item16 Item17 Item18
  Item19 Item20 Item21 Item22 Item23 Item24
  Item25 Item26 Item27 Item28 Item29 Item30
  Item31 Item32 Item33 Item34 Item35 Item36
  Item37 Item38 Item39 Item40 Item41 Item42
  Item43 Item44 Item45 Item46 Item47 Item48
  Item49 Item50 Item51 Item52 Item53 Item54
  Item55 Item56;",
  OUTPUT = "stdyx;",
  rdata = simulated_test_data
)

# finally, call the function with some minor changes to the default values.
abilityShortForm <- antcolony.mplus(
  ants = 3, evaporation = 0.7,
  mplus = initial.MplusAutomation.model, list.items = list.items, full = 56,
  i.per.f = 15, factors = "Ability", steps = 3, max.run = 50, resultfile = NULL,
  summaryfile = "C:/Users/lordmaxwell/Desktop/summary.txt",
  min.CFI = 0.95, min.TLI = 0.95, max.RMSEA = 0.06,
  feedbackfile = "C:/Users/lordmaxwell/Desktop/iteration.html", Mplus.Automation = TRUE,
  dataOut = "exampleModel.dat",
  modelOut = "exampleModel.inp"
)
}
}
\references{
\doi{10.1080/00273170802285743}
}
\seealso{
\code{\link{antcolony.lavaan}}

Other Ant Colony Algorithms: 
\code{\link{antcolony.lavaan}()}
}
\author{
Walter Leite; Anthony W Raborn, \email{anthony.w.raborn@gmail.com}
}
\concept{Ant Colony Algorithms}
