% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_grid.R
\name{plot_grid}
\alias{plot_grid}
\title{plot_grid}
\usage{
plot_grid(indicator_array, lower_bds, upper_bds, parameter_names = NULL)
}
\arguments{
\item{indicator_array}{An 2-dimensional indicator array generated by \code{confidence_grid} or \code{grid_projection}.}

\item{lower_bds}{A vector containing the lower bounds for the parameter search space.}

\item{upper_bds}{A vector containing the upper bounds for the parameter search space.}

\item{parameter_names}{An optional vector argument specifying the names of each parameter}
}
\value{
A grid plot showing the confidence regions.
}
\description{
projects the indicator array generated by confidence_grid down to 2d for visualization
}
\examples{
### Note that the examples may take a few seconds to run.
### Regular normal
set.seed(123)
n <- 50 # sample size
R <- 50 # Repro sample size (should be at least 200 for accuracy in practice)
alpha <- .05 # significance level
tol <- 1e-2 # tolerance for the confidence set
s_obs <- c(1.12, 0.67) # the observed sample mean
seeds <- matrix(rnorm(R * (n + 2)), nrow = R, ncol = n + 2) # pre-generated seeds

# this function computes the repro statistics given the seeds and the parameter
s_sample <- function(seeds, theta) {
  # generate the raw data points
  raw_data <- theta[1] + sqrt(theta[2]) * seeds[, 1:n]

  # compute the regular statistics
  s_mean <- apply(raw_data, 1, mean)
  s_var <- apply(raw_data, 1, var)

  return(cbind(s_mean, s_var))
}

lower_bds <- c(0.5, 0.4) # lower bounds for the parameter search region
upper_bds <- c(1.5, 1.4) # upper bounds for the parameter search region

resolution = 10  # resolution of the grid

result <- confidence_grid(alpha, lower_bds, upper_bds, seeds, s_sample, s_obs, tol, resolution)
ind_arr <- result$ind_array
parameter_names <- c("mean", "variance") # specifying the names of each parameter
plot_grid(ind_arr, lower_bds, upper_bds, parameter_names)

}
