% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{run_simulations_2x2_rom}
\alias{run_simulations_2x2_rom}
\title{Run Simulations for a 2x2 Crossover Design with Ratio of Means (ROM) test}
\usage{
run_simulations_2x2_rom(
  nsim,
  n,
  muT,
  muR,
  SigmaW,
  lequi_tol,
  uequi_tol,
  alpha,
  sigmaB,
  dropout,
  Eper,
  Eco,
  typey,
  adseq,
  k,
  arm_seed
)
}
\arguments{
\item{nsim}{Integer. The number of simulations to run.}

\item{n}{Integer. The sample size per period.}

\item{muT}{Numeric vector. Mean outcomes for the active treatment.}

\item{muR}{Numeric vector. Mean outcomes for the reference treatment.}

\item{SigmaW}{Numeric matrix. Within-subject covariance matrix for endpoints.}

\item{lequi_tol}{Numeric vector. Lower equivalence thresholds for each endpoint.}

\item{uequi_tol}{Numeric vector. Upper equivalence thresholds for each endpoint.}

\item{alpha}{Numeric vector. Significance levels for hypothesis testing across endpoints.}

\item{sigmaB}{Numeric. Between-subject variance for the crossover model.}

\item{dropout}{Numeric vector of size 2. Dropout rates for each sequence.}

\item{Eper}{Numeric vector. Expected period effects for each sequence.}

\item{Eco}{Numeric vector. Expected carryover effects for each sequence.}

\item{typey}{Integer vector indicating the classification of each endpoint, where \code{1} corresponds to a primary endpoint and \code{2} corresponds to a secondary endpoint.}

\item{adseq}{Logical. If \code{TRUE}, applies sequential (hierarchical) testing.}

\item{k}{Integer. Minimum number of endpoints required for equivalence.}

\item{arm_seed}{Integer vector. Random seed for each simulation.}
}
\value{
A numeric matrix where each column stores simulation results:
The first row (\code{totaly}) represents the overall equivalence decision (1 = success, 0 = failure).
Subsequent rows contain equivalence decisions per endpoint,
mean estimates for the treatment group, mean estimates for the reference group,
standard deviations for treatment, and standard deviations for reference.

@author Thomas Debray \email{tdebray@fromdatatowisdom.com}
}
\description{
This function simulates a 2x2 crossover trial across multiple iterations.
It evaluates equivalence across multiple endpoints using the
Ratio of Means (ROM) test.
}
\details{
This function evaluates equivalence using the Ratio of Means (ROM) test.
Equivalence is determined based on predefined lower \code{lequi_tol} and upper \code{uequi_tol} equivalence thresholds,
and hypothesis testing is conducted at the specified significance level \code{alpha}.
If \code{adseq} is \code{TRUE}, primary endpoints must establish equivalence before secondary endpoints are evaluated.
The sample size per period is adjusted based on dropout rates, ensuring valid study conclusions.
The simulation incorporates within-subject correlation using \code{SigmaW} and accounts for between-subject variance with \code{sigmaB}.
Expected period effects \code{Eper} and carryover effects \code{Eco} are included in the model.
A fixed random seed \code{arm_seed} is used to ensure reproducibility across simulations.//'
}
