% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsCorr.R
\name{EnsCorr}
\alias{EnsCorr}
\title{Correlation skill analysis for ensemble forecasts}
\usage{
EnsCorr(ens, obs, R.new = NA)
}
\arguments{
\item{ens}{a N*R matrix representing N time instances of real-valued R-member ensemble forecasts}

\item{obs}{a numeric vector of length N with real-valued observations}

\item{R.new}{positive number, can be \code{Inf}, ensemble size for which correlation skill should be estimated, default is NA for using the actual size R of the ensemble}
}
\value{
A vector with 4 entries:
\itemize{
\item \code{cmy}: Correlation skill of the ensemble mean forecast
\item \code{cmy_adj}: Correlation skill of the ensemble mean forecast adjusted to ensemble size R.new
\item \code{cxx}: Average correlation between ensemble members
\item \code{cxy}: Average correlation between individual ensemble members and observation
}
}
\description{
Calculate correlation between forecasts and observations for an ensemble forecast, including an adjustment for finite ensemble sizes
}
\examples{
data(eurotempforecast)
EnsCorr(ens, obs, R.new=Inf)
}
\references{
Von Storch, Zwiers (2001): Statistical analysis in climate research. Cambridge University Press.

Murphy (1990), Assessment of the practical utility of extended range ensemble forecasts, Q. J. R. Meteorol. Soc., 116, 89-125.
}
\seealso{
Corr, CorrDiff
}
