% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMS_FH_MisSpecification_SUMCA.R
\name{mspe_PMS_Mis_FH_SUMCA}
\alias{mspe_PMS_Mis_FH_SUMCA}
\title{Post model selection MSPE estimation in FH model with mean mis-specification using SUMCA method. Calculate the post-model selection mspe of Fay-Herriot model with mean mis-specification using SUMCA method.}
\usage{
mspe_PMS_Mis_FH_SUMCA(m, p, X, beta1, beta2, A, D, K, R)
}
\arguments{
\item{m}{number of small areas}

\item{p}{number of fixed model parameters}

\item{X}{covariates}

\item{beta1}{regression coefficient}

\item{beta2}{regression coefficient}

\item{A}{variance of area-specific random effects}

\item{D}{sampling variance}

\item{K}{number of Monte Carlo for the SUMCA method}

\item{R}{number of simulation runs}
}
\value{
Par: return estimation of model parameters

MSPE.TRUE.Final: return empirical MSPE of small area predictor

mspe.Sumca.Final: return mspe of small area predictor using the SUMCA method

RB.SUMCA: return relative bias (RB) of mspe of small area predictor using the SUMCA method
}
\description{
Post model selection MSPE estimation in FH model with mean mis-specification using SUMCA method. Calculate the post-model selection mspe of Fay-Herriot model with mean mis-specification using SUMCA method.
}
\examples{
mspe_PMS_Mis_FH_SUMCA(20,3,matrix(runif(60,0,1),nrow=20,byrow=TRUE)
,c(1,1,1),c(1,1,1),10,2.5,10,10)

}
