% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cindex.R
\name{Cindex}
\alias{Cindex}
\title{Concordance index for right censored survival time data}
\usage{
Cindex(object, predicted, t_star = -1)
}
\arguments{
\item{object}{object of class \code{Surv} created by Surv function.}

\item{predicted}{a vector containing the predicted survival time or probability of each observation.}

\item{t_star}{the timepoint at which the C-index you want to calculate.}
}
\value{
Estimates of the C-index.
}
\description{
Concordance index is a rank correlation measures between a variable X and a possibly
censored variable Y, with event/censoring indicator. In survival analysis, a pair of patients is called concordant if the risk of
the event predicted by a model is lower for the patient who experiences the
event at a later timepoint. The concordance probability (C-index) is the
frequency of concordant pairs among all pairs of subjects. It can be used to
measure and compare the discriminative power of a risk prediction models.
}
\details{
Pairs with identical observed times, where one is uncensored and one is
censored, are always considered usuable (independent of the value of
\code{tiedOutcomeIn}), as it can be assumed that the event occurs at a later
timepoint for the censored observation.

For uncensored response the result equals the one obtained with the
functions \code{rcorr.cens} and \code{rcorrcens} from the \code{Hmisc}
package (see examples).
}
\examples{
library(survival)
time <- c(1, 1, 2, 2, 2, 2, 2, 2)
status <- c(0, 1, 1, 0, 1, 1, 0, 1)
predicted <- c(2, 3, 3, 3, 4, 2, 4, 3)
Cindex(Surv(time, status), predicted)

}
\references{
Ishwaran, H. ,  Kogalur, U. B. ,  Blackstone, E. H. , &  Lauer, M. S. . (2008). Random survival forests. Journal of Thoracic Oncology Official Publication of the International Association for the Study of Lung Cancer, 2(12), 841-860.

Kang, L. ,  Chen, W. ,  Petrick, N. A. , &  Gallas, B. D. . (2015). Comparing two correlated c indices with right-censored survival outcome: a one-shot nonparametric approach. Statistics in Medicine, 34(4).

TA Gerds, MW Kattan, M Schumacher, and C Yu. Estimating a time-dependent
concordance index for survival prediction models with covariate dependent
censoring. Statistics in Medicine, Ahead of print:to appear, 2013. DOI =
10.1002/sim.5681

Wolbers, M and Koller, MT and Witteman, JCM and Gerds, TA (2013) Concordance
for prognostic models with competing risks Research report 13/3. Department
of Biostatistics, University of Copenhagen

Andersen, PK (2012) A note on the decomposition of number of life years lost
according to causes of death Research report 12/2. Department of
Biostatistics, University of Copenhagen

Paul Blanche, Michael W Kattan, and Thomas A Gerds. The c-index is not
proper for the evaluation of-year predicted risks. Biostatistics, 20(2):
347--357, 2018.
}
\author{
Hanpu Zhou \email{zhouhanpu@csu.edu.cn}
}
