% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tad.R
\name{null_model_distribution_stats}
\alias{null_model_distribution_stats}
\title{Compare a value to random values}
\usage{
null_model_distribution_stats(
  observed_value,
  random_values,
  significance_threshold = c(0.05, 0.95),
  remove_nas = TRUE
)
}
\arguments{
\item{observed_value}{the observed value}

\item{random_values}{the random Values}

\item{significance_threshold}{the array of values used to compute the
quantile (c(0.025, 0.975) by default)}

\item{remove_nas}{boolean - tells weither to remoe NAs or not}
}
\value{
a list corresponding to :
\itemize{
\item the observed value
\item quantile values (minimum significance threshold)
\item quantile values (maximum significance threshold)
\item significance (observed value not in quantile values)
}
}
\description{
Compute different statistics (standardized by
the distribution of random  values).
}
\examples{

null_model_distribution_stats(
  observed_value = 2,
  random_values = c(1, 4, 5, 6, 8),
  significance_threshold = c(0.025, 0.975)
)

}
\concept{Statistics}
