% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimalRule.R
\name{OptimalRule}
\alias{OptimalRule}
\title{Optimal Tripartite Rule}
\usage{
OptimalRule(Obj, lambda)
}
\arguments{
\item{Obj}{An object of class TGST.}

\item{lambda}{A user-specified weight that reflects relative loss for the two types of misdiagnoses, taking value in \eqn{[0,1]}. \eqn{Loss=\lambda*I(FN)+(1-\lambda)*I(FP)}.}
}
\value{
Optimal tripartite rule.
}
\description{
\code{OptimalRule} is the main function of \code{TGST} and it gives you the optimal tripartite rule that minimizes the min-\eqn{\lambda} risk based on the type of user selected approach. 
The function takes the risk score and true disease status from a training data set and returns the optimal tripartite rule under the specified proportion of patients able to take gold standard test.
}
\examples{
d = Simdata
Z = d$Z # True Disease Status
S = d$S # Risk Score
phi = 0.1 #10\% of patients taking viral load test
lambda = 0.5
Obj = TGST(Z, S, phi, method="nonpar")
OptimalRule(Obj, lambda)
}
\keyword{rules}
