% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_htest.R
\name{simple_htest}
\alias{simple_htest}
\alias{simple_htest.default}
\alias{simple_htest.formula}
\title{One, Two, and Paired Samples Hypothesis Tests with Extended Options}
\usage{
simple_htest(
  x,
  ...,
  paired = FALSE,
  alternative = c("two.sided", "less", "greater", "equivalence", "minimal.effect"),
  mu = NULL,
  alpha = 0.05
)

\method{simple_htest}{default}(
  x,
  y = NULL,
  test = c("t.test", "wilcox.test", "brunner_munzel"),
  paired = FALSE,
  alternative = c("two.sided", "less", "greater", "equivalence", "minimal.effect"),
  mu = NULL,
  alpha = 0.05,
  ...
)

\method{simple_htest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{further arguments to be passed to or from the underlying test functions.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{alternative}{the alternative hypothesis:
- "two.sided": different from mu (default)
- "less": less than mu
- "greater": greater than mu
- "equivalence": between specified bounds
- "minimal.effect": outside specified bounds}

\item{mu}{a number or vector specifying the null hypothesis value(s):
- For standard alternatives (two.sided, less, greater): a single value (default: 0 for t-test/wilcox.test, 0.5 for brunner_munzel)
- For equivalence/minimal.effect: either a single value (symmetric bounds will be created) or a vector of two values representing the lower and upper bounds}

\item{alpha}{alpha level (default = 0.05)}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{test}{a character string specifying the type of hypothesis test to use:
- "t.test": Student's t-test (parametric, default)
- "wilcox.test": Wilcoxon-Mann-Whitney test (non-parametric)
- "brunner_munzel": Brunner-Munzel test (non-parametric)

You can specify just the initial letter (e.g., "t" for "t.test").}

\item{formula}{a formula of the form lhs ~ rhs where lhs is a numeric variable giving the data values and rhs either 1 for a one-sample or paired test or a factor with two levels giving the corresponding groups. If lhs is of class "Pair" and rhs is 1, a paired test is done.}

\item{data}{an optional matrix or data frame (or similar: see model.frame) containing the variables in the formula formula. By default the variables are taken from environment(formula).}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. Defaults to getOption("na.action").}
}
\value{
A list with class \code{"htest"} containing the following components:
\itemize{
\item statistic: the value of the test statistic.
\item parameter: the parameter(s) for the test statistic (e.g., degrees of freedom for t-tests).
\item p.value: the p-value for the test.
\item conf.int: a confidence interval appropriate to the specified alternative hypothesis.
\item estimate: the estimated effect (e.g., mean difference for t-tests, probability estimate for Brunner-Munzel).
\item null.value: the specified hypothesized value(s). For equivalence and minimal effect tests, this will be two values.
\item stderr: the standard error of the estimate (for t-tests).
\item alternative: a character string describing the alternative hypothesis.
\item method: a character string indicating what type of test was performed.
\item data.name: a character string giving the name(s) of the data.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

Performs statistical hypothesis tests with extended functionality beyond standard implementations.
Supports t-tests, Wilcoxon-Mann-Whitney tests, and Brunner-Munzel tests with additional
alternatives such as equivalence and minimal effect testing.
}
\details{
This function provides a unified interface to several common hypothesis tests with expanded
alternative hypotheses, particularly for equivalence testing and minimal effect testing.

When \code{alternative = "equivalence"}, the test evaluates whether the effect is contained
within the bounds specified by \code{mu}. This corresponds to the alternative hypothesis that
the true effect is between the specified bounds. The function performs two one-sided tests and
returns the most conservative result (highest p-value).

When \code{alternative = "minimal.effect"}, the test evaluates whether the effect is outside
the bounds specified by \code{mu}. This corresponds to the alternative hypothesis that the true
effect is either less than the lower bound or greater than the upper bound. The function performs
two one-sided tests and returns the most significant result (lowest p-value).

For standard alternatives ("two.sided", "less", "greater"), the function behaves similarly to
the underlying test functions with some additional standardization in the output format.

The interpretation of \code{mu} depends on the test used:
\itemize{
\item For t-test and wilcox.test: mu represents the difference in means/medians (default: 0)
\item For brunner_munzel: mu represents the probability that a randomly selected value from the first sample exceeds a randomly selected value from the second sample (default: 0.5)
}

If \code{mu} is a single value for equivalence or minimal effect alternatives, symmetric bounds
will be created automatically:
\itemize{
\item For t-test and wilcox.test: bounds become c(mu, -mu)
\item For brunner_munzel: bounds become c(mu, abs(mu-1))
}
}
\section{Purpose}{

Use this function when:
\itemize{
\item You need a unified interface for different types of hypothesis tests
\item You want to perform equivalence testing or minimal effect testing with non-parametric methods
\item You need more flexibility in hypothesis testing than provided by standard functions
\item You want to easily switch between parametric and non-parametric methods
}
}

\examples{
# Example 1: Basic t-test with equivalence alternative
# Testing if the difference in mpg between automatic and manual transmission cars
# is equivalent within ±3 units
data(mtcars)
simple_htest(mpg ~ am, data = mtcars, alternative = "equivalence", mu = 3)

# Example 2: Using a non-parametric test with minimal effect alternative
# Testing if the effect of transmission type on mpg is meaningfully large
# (either less than -2 or greater than 2)
simple_htest(mpg ~ am, data = mtcars,
             test = "wilcox",
             alternative = "minimal.effect",
             mu = c(-2, 2))

# Example 3: Paired samples test
# Using the sleep dataset to test if drug has an effect on sleep
data(sleep)
with(sleep, simple_htest(x = extra[group == 1],
                        y = extra[group == 2],
                        paired = TRUE,
                        alternative = "greater"))

# Example 4: Brunner-Munzel test
# Testing if values in one group tend to exceed values in another
set.seed(123)
group1 <- rnorm(20, mean = 5, sd = 1)
group2 <- rnorm(20, mean = 6, sd = 2)
simple_htest(x = group1, y = group2,
             test = "brunner_munzel",
             alternative = "less")

}
\seealso{
Other TOST: 
\code{\link{boot_log_TOST}()},
\code{\link{boot_t_TOST}()},
\code{\link{t_TOST}()},
\code{\link{tsum_TOST}()},
\code{\link{wilcox_TOST}()}

Other htest: 
\code{\link{as_htest}()},
\code{\link{htest-helpers}}

Other htest: 
\code{\link{as_htest}()},
\code{\link{htest-helpers}}
}
\concept{TOST}
\concept{htest}
