% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeDep_plot.R
\name{TreeDep_plot}
\alias{TreeDep_plot}
\title{TreeDep_plot - Generates a plot for selected variables and dates.}
\usage{
TreeDep_plot(my_data, variable1, variable2 = "Non-existent", start_month,
  start_day, stop_month, stop_day)
}
\arguments{
\item{my_data}{A data frame containing hourly data pollutant concentration and other variables (Dates (e.g. 01/01/2016  00:00:00), Hum (\%), Pres (kPa), Precip (mm), Rad (W m-2), Temp (C), Wind (m s-1), Daylight (Night or Daylight), BAI, LAI)}

\item{variable1}{Variable to be plotted (e.g., "Dep_NO2", "Conc_O3", "Wind", "Temp")}

\item{variable2}{Variable to be plotted (e.g., "Dep_NO2", "Conc_O3", "Wind", "Temp")}

\item{start_month}{First month of the year in the plot (between 1 and 12; e.g., 3)}

\item{start_day}{First day of the month in the plot (between 1 and 31; e.g., 4)}

\item{stop_month}{Last month of the year in the plot (between 1 and 12; e.g., 11)}

\item{stop_day}{Last day of the month in the plot (between 1 and 31; e.g., 22)}
}
\value{
A plot with the variables and dates selected
}
\description{
TreeDep_plot - Generates a plot for selected variables and dates.
}
\details{
The variables that can be plotted are: "Hum", "Pres", "Precip", "Rad", "Temp", "Wind", "BAI", "LAI", "Fric_vel", "Res_aero", "Res_boun_CO2", "Res_soil", "Conc_NO2", "Dep_NO2", "Dep_vel_NO2", "Res_boun_NO2", "Res_cuti_NO2", "Res_stom_NO2", "Res_meso_NO2", "Res_cano_NO2", "Res_Tot_NO2", "Conc_O3", "Dep_O3", "Dep_vel_O3", "Res_boun_O3", "Res_cuti_O3", "Res_stom_O3", "Res_meso_O3", "Res_cano_O3", "Res_Tot_O3", "Conc_SO2", "Dep_SO2", "Dep_vel_SO2", "Res_boun_SO2", "Res_cuti_SO2", "Res_stom_SO2", "Res_meso_SO2", "Res_cano_SO2", "Res_Tot_SO2",  "Conc_CO", "Dep_CO", "Dep_vel_CO", "Res_boun_CO", "Res_cano_CO", "Res_Tot_CO", "Conc_PM10", "Dep_PM10", "Dep_vel_PM10".
}
\examples{

TreeDep_plot(my_data = Bizkaia_data,
variable1 = "Dep_PM10",
variable2 = "Wind",
start_month = 6,
stop_month = 7,
start_day = 25,
stop_day = 3)

}
