% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data_LMMsolver.R
\name{prepare_data_LMMsolver}
\alias{prepare_data_LMMsolver}
\title{Process data to fit model with LMMsolver}
\usage{
prepare_data_LMMsolver(Y = Y, R = R, Z = NULL, bins = bins)
}
\arguments{
\item{Y}{A matrix (or 3d-array) of event counts of dimension nu by ns
(or nu by ns by n).}

\item{R}{A matrix (or 3d-array) of exposure times of dimension nu by ns
(or nu by ns by n).}

\item{Z}{(optional) A regression matrix of covariates values of dimensions
n by p.}

\item{bins}{a list with the specification for the bins. This is created by
the function \code{prepare_data}. If a list prepared externally from such function
if provided, it should contain the following elements:
* \code{bins_u} A vector of bins extremes for the time scale \code{u}.
* \code{midu} A vector with the midpoints of the bins over \code{u}.
* \code{nu} The number of bins over \code{u}.
* \code{bins_s} A vector of bins extremes for the time scale \code{s}.
* \code{mids} A vector with the midpoints of the bins over \code{s}.
* \code{ns} The number of bins over \code{s}.}
}
\value{
A dataset in long form to fit the model with LMMsolver
}
\description{
Process data to fit model with LMMsolver
}
