% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_identifier_dim_dist.R
\name{vis_identifier_dim_dist}
\alias{vis_identifier_dim_dist}
\title{Visualize the distribution difference of samples after Molecule Identifier dimensionality reduction analysis}
\usage{
vis_identifier_dim_dist(
  dataset = NULL,
  ids = NULL,
  grp_df,
  samples = NULL,
  return.data = FALSE,
  DR_method = c("PCA", "UMAP", "tSNE"),
  add_margin = NULL,
  palette = "Set1"
)
}
\arguments{
\item{dataset}{the dataset to obtain identifiers.}

\item{ids}{the molecule identifiers.}

\item{grp_df}{When \code{dataset} and \code{id} are all not \code{NULL}, it should be a \code{data.frame} with 2 columns.
\itemize{
\item The first column refers to sample ID.
\item The second column refers to groups indicated in axis X.
}}

\item{samples}{default is \code{NULL}, can be common sample names for two datasets.}

\item{return.data}{whether to reture the raw meta/matrix data (list) instead of plot}

\item{DR_method}{the dimensionality reduction method}

\item{add_margin}{the marginal plot (NULL, "density", "boxplot")}

\item{palette}{the color setting of RColorBrewer}
}
\value{
a \code{ggplot} object.
}
\description{
NOTE: the dataset must be dense matrix in UCSC Xena data hubs.
}
\examples{
# vis_identifier_dim_dist(expr_dataset, ids, grp_df, DR_method="PCA")
}
