#' @family pooled estimates (two-sample)
#' @inherit uM6pool title description params
#' @return Pooled estimate of a product of second and fourth central moments
#'   \eqn{\mu_2 \mu_4}{\mu[2] \mu[4]}, where \eqn{\mu_2}{\mu[2]} and
#'   \eqn{\mu_4}{\mu[4]} are second and fourth central moments respectively.
#' @examples
#' nx <- 10
#' ny <- 8
#' shp <- 3
#' smpx <- rgamma(nx, shape = shp) - shp
#' smpy <- rgamma(ny, shape = shp)
#' mx <- mean(smpx)
#' my <- mean(smpy)
#' m  <- numeric(6)
#' for (j in 2:6) {
#'   m[j] <- mean(c((smpx - mx)^j, (smpy - my)^j))
#' }
#' uM2M4pool(m[2], m[3], m[4], m[6], nx, ny)
#' @export
uM2M4pool <- function(m2, m3, m4, m6, n_x, n_y) {
    (m2*m4*n_x^7*n_y^15 + 180*m2^3*n_x^12 + (8*m2*m4*n_x^8 - (12*m2^3 - 4*m3^2 + 34*m2*m4 + m6)*n_x^7 + (15*m2^3 + 19*m2*m4)*n_x^6 + 15*m2*m4*n_x^4 - (9*m2^3 + 20*m2*m4)*n_x^5 - 5*m2*m4*n_x^3)*n_y^14 - 2340*m2^3*n_x^11 + (28*m2*m4*n_x^9 - 7*(12*m2^3 - 4*m3^2 + 34*m2*m4 + m6)*n_x^8 + (456*m2^3 - 124*m3^2 + 643*m2*m4 + 28*m6)*n_x^7 - (765*m2^3 - 92*m3^2 + 625*m2*m4 + 14*m6)*n_x^6 + (738*m2^3 - 66*m3^2 + 613*m2*m4 + 9*m6)*n_x^5 - (426*m2^3 + 20*m3^2 + 375*m2*m4 + 3*m6)*n_x^4 + 45*m2^3*n_x + 15*(21*m2^3 + 2*m3^2 + 8*m2*m4)*n_x^3 - 10*(21*m2^3 + 2*m2*m4)*n_x^2)*n_y^13 + 2520*m2^3*n_x^10 + (56*m2*m4*n_x^10 - 21*(12*m2^3 - 4*m3^2 + 34*m2*m4 + m6)*n_x^9 + 2*(1218*m2^3 - 372*m3^2 + 1739*m2*m4 + 84*m6)*n_x^8 - (8280*m2^3 - 2020*m3^2 + 7779*m2*m4 + 409*m6)*n_x^7 + (14529*m2^3 - 2194*m3^2 + 9058*m2*m4 + 322*m6)*n_x^6 - (16440*m2^3 - 1792*m3^2 + 8434*m2*m4 + 221*m6)*n_x^5 + 2*(6291*m2^3 - 275*m3^2 + 2490*m2*m4 + 48*m6)*n_x^4 - 1020*m2^3*n_x - (7437*m2^3 - 100*m3^2 + 1870*m2*m4 + 12*m6)*n_x^3 + 180*m2^3 + 15*(227*m2^3 - 8*m3^2 + 31*m2*m4)*n_x^2)*n_y^12 - 360*m2^3*n_x^9 + (70*m2*m4*n_x^11 - 35*(12*m2^3 - 4*m3^2 + 34*m2*m4 + m6)*n_x^10 + (5880*m2^3 - 1860*m3^2 + 8429*m2*m4 + 420*m6)*n_x^9 - (30960*m2^3 - 8812*m3^2 + 30745*m2*m4 + 1849*m6)*n_x^8 + 2*(41247*m2^3 - 9370*m3^2 + 30353*m2*m4 + 1801*m6)*n_x^7 - (136230*m2^3 - 21266*m3^2 + 72757*m2*m4 + 3252*m6)*n_x^6 + (156582*m2^3 - 16730*m3^2 + 63782*m2*m4 + 2161*m6)*n_x^5 - (132750*m2^3 - 7226*m3^2 + 36147*m2*m4 + 952*m6)*n_x^4 + 3*(29167*m2^3 - 860*m3^2 + 4420*m2*m4 + 58*m6)*n_x^3 - 2340*m2^3 - 5*(8763*m2^3 - 258*m3^2 + 640*m2*m4)*n_x^2 + 15*(971*m2^3 - 12*m3^2 + 12*m2*m4)*n_x)*n_y^11 + (56*m2*m4*n_x^12 - 35*(12*m2^3 - 4*m3^2 + 34*m2*m4 + m6)*n_x^11 + 10*(777*m2^3 - 248*m3^2 + 1115*m2*m4 + 56*m6)*n_x^10 - (56754*m2^3 - 16980*m3^2 + 57535*m2*m4 + 3600*m6)*n_x^9 + (211023*m2^3 - 56270*m3^2 + 170735*m2*m4 + 11654*m6)*n_x^8 - 2*(230157*m2^3 - 49153*m3^2 + 149006*m2*m4 + 9886*m6)*n_x^7 + 2*(331839*m2^3 - 51240*m3^2 + 168846*m2*m4 + 9178*m6)*n_x^6 - (669819*m2^3 - 71206*m3^2 + 272133*m2*m4 + 11528*m6)*n_x^5 + 2*(241929*m2^3 - 14749*m3^2 + 73638*m2*m4 + 2271*m6)*n_x^4 - (252519*m2^3 - 10670*m3^2 + 55190*m2*m4 + 684*m6)*n_x^3 + 2520*m2^3 + 3*(31190*m2^3 - 1770*m3^2 + 5135*m2*m4 - 24*m6)*n_x^2 - 30*(749*m2^3 - 42*m3^2 + 78*m2*m4)*n_x)*n_y^10 + (28*m2*m4*n_x^13 - 21*(12*m2^3 - 4*m3^2 + 34*m2*m4 + m6)*n_x^12 + (5880*m2^3 - 1860*m3^2 + 8429*m2*m4 + 420*m6)*n_x^11 - (56754*m2^3 - 16980*m3^2 + 57535*m2*m4 + 3600*m6)*n_x^10 + 2*(142320*m2^3 - 39658*m3^2 + 118489*m2*m4 + 8365*m6)*n_x^9 - (811038*m2^3 - 201312*m3^2 + 585969*m2*m4 + 44576*m6)*n_x^8 + (1438911*m2^3 - 289636*m3^2 + 884514*m2*m4 + 67823*m6)*n_x^7 - (1708635*m2^3 - 260674*m3^2 + 886891*m2*m4 + 61448*m6)*n_x^6 + (1387413*m2^3 - 151404*m3^2 + 615642*m2*m4 + 36716*m6)*n_x^5 - (760920*m2^3 - 50462*m3^2 + 280739*m2*m4 + 13607*m6)*n_x^4 + 15*(18246*m2^3 - 856*m3^2 + 5551*m2*m4 + 146*m6)*n_x^3 - 360*m2^3 - 2*(31335*m2^3 - 2730*m3^2 + 8785*m2*m4 - 36*m6)*n_x^2 + 120*(71*m2^3 - 12*m3^2 + 21*m2*m4)*n_x)*n_y^9 + (8*m2*m4*n_x^14 - 7*(12*m2^3 - 4*m3^2 + 34*m2*m4 + m6)*n_x^13 + 2*(1218*m2^3 - 372*m3^2 + 1739*m2*m4 + 84*m6)*n_x^12 - (30960*m2^3 - 8812*m3^2 + 30745*m2*m4 + 1849*m6)*n_x^11 + (211023*m2^3 - 56270*m3^2 + 170735*m2*m4 + 11654*m6)*n_x^10 - (811038*m2^3 - 201312*m3^2 + 585969*m2*m4 + 44576*m6)*n_x^9 + 4*(459774*m2^3 - 101653*m3^2 + 302872*m2*m4 + 25766*m6)*n_x^8 - (2641437*m2^3 - 475674*m3^2 + 1536427*m2*m4 + 140172*m6)*n_x^7 + (2511441*m2^3 - 351054*m3^2 + 1287939*m2*m4 + 116330*m6)*n_x^6 - (1564404*m2^3 - 155646*m3^2 + 716379*m2*m4 + 61483*m6)*n_x^5 + 6*(98885*m2^3 - 4960*m3^2 + 40105*m2*m4 + 3166*m6)*n_x^4 - 10*(11475*m2^3 - 18*m3^2 + 4210*m2*m4 + 222*m6)*n_x^3 + 24*(270*m2^3 - 25*m3^2 + 145*m2*m4 - 6*m6)*n_x^2 + 360*(m2^3 + m3^2 - m2*m4)*n_x)*n_y^8 + (m2*m4*n_x^15 - (12*m2^3 - 4*m3^2 + 34*m2*m4 + m6)*n_x^14 + (456*m2^3 - 124*m3^2 + 643*m2*m4 + 28*m6)*n_x^13 - (8280*m2^3 - 2020*m3^2 + 7779*m2*m4 + 409*m6)*n_x^12 + 2*(41247*m2^3 - 9370*m3^2 + 30353*m2*m4 + 1801*m6)*n_x^11 - 2*(230157*m2^3 - 49153*m3^2 + 149006*m2*m4 + 9886*m6)*n_x^10 + (1438911*m2^3 - 289636*m3^2 + 884514*m2*m4 + 67823*m6)*n_x^9 - (2641437*m2^3 - 475674*m3^2 + 1536427*m2*m4 + 140172*m6)*n_x^8 + 2*(1523745*m2^3 - 226688*m3^2 + 806778*m2*m4 + 83982*m6)*n_x^7 - 2*(1136565*m2^3 - 138854*m3^2 + 551486*m2*m4 + 60601*m6)*n_x^6 + 15*(69967*m2^3 - 6460*m3^2 + 31637*m2*m4 + 3550*m6)*n_x^5 - 2*(125205*m2^3 - 3630*m3^2 + 51470*m2*m4 + 6168*m6)*n_x^4 + 24*(520*m2^3 + 205*m3^2 + 105*m2*m4 + 23*m6)*n_x^3 + 72*(45*m2^3 - 10*m3^2 + 20*m2*m4 + 2*m6)*n_x^2)*n_y^7 + ((15*m2^3 + 19*m2*m4)*n_x^14 - (765*m2^3 - 92*m3^2 + 625*m2*m4 + 14*m6)*n_x^13 + (14529*m2^3 - 2194*m3^2 + 9058*m2*m4 + 322*m6)*n_x^12 - (136230*m2^3 - 21266*m3^2 + 72757*m2*m4 + 3252*m6)*n_x^11 + 2*(331839*m2^3 - 51240*m3^2 + 168846*m2*m4 + 9178*m6)*n_x^10 - (1708635*m2^3 - 260674*m3^2 + 886891*m2*m4 + 61448*m6)*n_x^9 + (2511441*m2^3 - 351054*m3^2 + 1287939*m2*m4 + 116330*m6)*n_x^8 - 2*(1136565*m2^3 - 138854*m3^2 + 551486*m2*m4 + 60601*m6)*n_x^7 + 6*(216900*m2^3 - 24950*m3^2 + 100655*m2*m4 + 12172*m6)*n_x^6 - 6*(73280*m2^3 - 7960*m3^2 + 33375*m2*m4 + 4234*m6)*n_x^5 + 120*(541*m2^3 - 31*m3^2 + 231*m2*m4 + 34*m6)*n_x^4 + 360*(m2^3 - 4*m3^2 + 4*m2*m4)*n_x^3)*n_y^6 - ((9*m2^3 + 20*m2*m4)*n_x^14 - (738*m2^3 - 66*m3^2 + 613*m2*m4 + 9*m6)*n_x^13 + (16440*m2^3 - 1792*m3^2 + 8434*m2*m4 + 221*m6)*n_x^12 - (156582*m2^3 - 16730*m3^2 + 63782*m2*m4 + 2161*m6)*n_x^11 + (669819*m2^3 - 71206*m3^2 + 272133*m2*m4 + 11528*m6)*n_x^10 - (1387413*m2^3 - 151404*m3^2 + 615642*m2*m4 + 36716*m6)*n_x^9 + (1564404*m2^3 - 155646*m3^2 + 716379*m2*m4 + 61483*m6)*n_x^8 - 15*(69967*m2^3 - 6460*m3^2 + 31637*m2*m4 + 3550*m6)*n_x^7 + 6*(73280*m2^3 - 7960*m3^2 + 33375*m2*m4 + 4234*m6)*n_x^6 - 48*(2205*m2^3 - 325*m3^2 + 1090*m2*m4 + 141*m6)*n_x^5 + 360*(26*m2^3 - 5*m3^2 + 15*m2*m4 + 2*m6)*n_x^4)*n_y^5 + (15*m2*m4*n_x^14 - (426*m2^3 + 20*m3^2 + 375*m2*m4 + 3*m6)*n_x^13 + 2*(6291*m2^3 - 275*m3^2 + 2490*m2*m4 + 48*m6)*n_x^12 - (132750*m2^3 - 7226*m3^2 + 36147*m2*m4 + 952*m6)*n_x^11 + 2*(241929*m2^3 - 14749*m3^2 + 73638*m2*m4 + 2271*m6)*n_x^10 - (760920*m2^3 - 50462*m3^2 + 280739*m2*m4 + 13607*m6)*n_x^9 + 6*(98885*m2^3 - 4960*m3^2 + 40105*m2*m4 + 3166*m6)*n_x^8 - 2*(125205*m2^3 - 3630*m3^2 + 51470*m2*m4 + 6168*m6)*n_x^7 + 120*(541*m2^3 - 31*m3^2 + 231*m2*m4 + 34*m6)*n_x^6 - 360*(26*m2^3 - 5*m3^2 + 15*m2*m4 + 2*m6)*n_x^5)*n_y^4 - (5*m2*m4*n_x^14 - 15*(21*m2^3 + 2*m3^2 + 8*m2*m4)*n_x^13 + (7437*m2^3 - 100*m3^2 + 1870*m2*m4 + 12*m6)*n_x^12 - 3*(29167*m2^3 - 860*m3^2 + 4420*m2*m4 + 58*m6)*n_x^11 + (252519*m2^3 - 10670*m3^2 + 55190*m2*m4 + 684*m6)*n_x^10 - 15*(18246*m2^3 - 856*m3^2 + 5551*m2*m4 + 146*m6)*n_x^9 + 10*(11475*m2^3 - 18*m3^2 + 4210*m2*m4 + 222*m6)*n_x^8 - 24*(520*m2^3 + 205*m3^2 + 105*m2*m4 + 23*m6)*n_x^7 - 360*(m2^3 - 4*m3^2 + 4*m2*m4)*n_x^6)*n_y^3 - (10*(21*m2^3 + 2*m2*m4)*n_x^13 - 15*(227*m2^3 - 8*m3^2 + 31*m2*m4)*n_x^12 + 5*(8763*m2^3 - 258*m3^2 + 640*m2*m4)*n_x^11 - 3*(31190*m2^3 - 1770*m3^2 + 5135*m2*m4 - 24*m6)*n_x^10 + 2*(31335*m2^3 - 2730*m3^2 + 8785*m2*m4 - 36*m6)*n_x^9 - 24*(270*m2^3 - 25*m3^2 + 145*m2*m4 - 6*m6)*n_x^8 - 72*(45*m2^3 - 10*m3^2 + 20*m2*m4 + 2*m6)*n_x^7)*n_y^2 + 15*(3*m2^3*n_x^13 - 68*m2^3*n_x^12 + (971*m2^3 - 12*m3^2 + 12*m2*m4)*n_x^11 - 2*(749*m2^3 - 42*m3^2 + 78*m2*m4)*n_x^10 + 8*(71*m2^3 - 12*m3^2 + 21*m2*m4)*n_x^9 + 24*(m2^3 + m3^2 - m2*m4)*n_x^8)*n_y)/(n_x^7*n_y^15 + (8*n_x^8 - 45*n_x^7 + 25*n_x^6 - 23*n_x^5 + 15*n_x^4 - 5*n_x^3)*n_y^14 + (28*n_x^9 - 315*n_x^8 + 1041*n_x^7 - 1035*n_x^6 + 968*n_x^5 - 582*n_x^4 + 250*n_x^3 - 95*n_x^2 + 15*n_x)*n_y^13 + (56*n_x^10 - 945*n_x^9 + 5746*n_x^8 - 15009*n_x^7 + 18194*n_x^6 - 17382*n_x^5 + 11102*n_x^4 - 4984*n_x^3 + 1765*n_x^2 - 360*n_x + 60)*n_y^12 + 60*n_x^12 + (70*n_x^11 - 1575*n_x^10 + 14015*n_x^9 - 61245*n_x^8 + 138114*n_x^7 - 174283*n_x^6 + 163238*n_x^5 - 107571*n_x^4 + 52507*n_x^3 - 20705*n_x^2 + 5460*n_x - 780)*n_y^11 - 780*n_x^11 + (56*n_x^12 - 1575*n_x^11 + 18570*n_x^10 - 115728*n_x^9 + 403823*n_x^8 - 803772*n_x^7 + 969776*n_x^6 - 834367*n_x^5 + 498284*n_x^4 - 209069*n_x^3 + 65785*n_x^2 - 12810*n_x + 780)*n_y^10 + 780*n_x^10 + (28*n_x^13 - 945*n_x^12 + 14015*n_x^11 - 115728*n_x^10 + 565900*n_x^9 - 1656392*n_x^8 + 2913840*n_x^7 - 3198552*n_x^6 + 2405947*n_x^5 - 1196804*n_x^4 + 378693*n_x^3 - 82370*n_x^2 + 10845*n_x + 660)*n_y^9 + 660*n_x^9 + (8*n_x^14 - 315*n_x^13 + 5746*n_x^12 - 61245*n_x^11 + 403823*n_x^10 - 1656392*n_x^9 + 4192900*n_x^8 - 6526559*n_x^7 + 6365599*n_x^6 - 4065108*n_x^5 + 1560742*n_x^4 - 280282*n_x^3 + 8290*n_x^2 + 1290*n_x - 840)*n_y^8 - 840*n_x^8 + (n_x^15 - 45*n_x^14 + 1041*n_x^13 - 15009*n_x^12 + 138114*n_x^11 - 803772*n_x^10 + 2913840*n_x^9 - 6526559*n_x^8 + 9021718*n_x^7 - 7773202*n_x^6 + 4204679*n_x^5 - 1200142*n_x^4 + 38980*n_x^3 + 54690*n_x^2 - 6960*n_x + 120)*n_y^7 + 120*n_x^7 + (25*n_x^14 - 1035*n_x^13 + 18194*n_x^12 - 174283*n_x^11 + 969776*n_x^10 - 3198552*n_x^9 + 6365599*n_x^8 - 7773202*n_x^7 + 5924490*n_x^6 - 2796336*n_x^5 + 645586*n_x^4 + 19470*n_x^3 - 30120*n_x^2 + 2520*n_x)*n_y^6 - (23*n_x^14 - 968*n_x^13 + 17382*n_x^12 - 163238*n_x^11 + 834367*n_x^10 - 2405947*n_x^9 + 4065108*n_x^8 - 4204679*n_x^7 + 2796336*n_x^6 - 1209662*n_x^5 + 272430*n_x^4 - 7920*n_x^3 - 2760*n_x^2)*n_y^5 + (15*n_x^14 - 582*n_x^13 + 11102*n_x^12 - 107571*n_x^11 + 498284*n_x^10 - 1196804*n_x^9 + 1560742*n_x^8 - 1200142*n_x^7 + 645586*n_x^6 - 272430*n_x^5 + 63840*n_x^4 - 3480*n_x^3)*n_y^4 - (5*n_x^14 - 250*n_x^13 + 4984*n_x^12 - 52507*n_x^11 + 209069*n_x^10 - 378693*n_x^9 + 280282*n_x^8 - 38980*n_x^7 - 19470*n_x^6 - 7920*n_x^5 + 3480*n_x^4)*n_y^3 - 5*(19*n_x^13 - 353*n_x^12 + 4141*n_x^11 - 13157*n_x^10 + 16474*n_x^9 - 1658*n_x^8 - 10938*n_x^7 + 6024*n_x^6 - 552*n_x^5)*n_y^2 + 15*(n_x^13 - 24*n_x^12 + 364*n_x^11 - 854*n_x^10 + 723*n_x^9 + 86*n_x^8 - 464*n_x^7 + 168*n_x^6)*n_y)
}
