% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unbmom1.R
\name{uM2}
\alias{uM2}
\title{Unbiased central moment estimates}
\usage{
uM2(m2, n)
}
\arguments{
\item{m2}{naive biased variance estimate \eqn{m_2 = 1/n \sum_{i = 1}^n ((X_i
- \bar{X})^2}{m[2] = mean((X - X-bar)^2)} for a vector \code{X}.}

\item{n}{sample size.}
}
\value{
Unbiased variance estimate.
}
\description{
Calculate unbiased estimates of central moments and their powers and
products.
}
\examples{
n <- 10
smp <- rgamma(n, shape = 3)
m <- mean(smp)
m <- c(m, mean((smp - m[1])^2))
uM2(m[2], n) - var(smp)
}
\seealso{
Other unbiased estimates (one-sample): 
\code{\link{uM2M3}()},
\code{\link{uM2M4}()},
\code{\link{uM2pow2}()},
\code{\link{uM2pow3}()},
\code{\link{uM3}()},
\code{\link{uM3pow2}()},
\code{\link{uM4}()},
\code{\link{uM5}()},
\code{\link{uM6}()}
}
\concept{unbiased estimates (one-sample)}
