% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unbmom1.R
\name{uM2pow2}
\alias{uM2pow2}
\title{Unbiased central moment estimates}
\usage{
uM2pow2(m2, m4, n)
}
\arguments{
\item{m2}{naive biased variance estimate \eqn{m_2 = 1/n \sum_{i = 1}^n ((X_i
- \bar{X})^2}{m[2] = mean((X - X-bar)^2)} for a vector \code{X}.}

\item{m4}{naive biased fourth central moment estimate \eqn{m_4 = 1/n \sum_{i
= 1}^n ((X_i - \bar{X})^4}{m[4] = mean((X - X-bar)^4)} for a vector
\code{X}.}

\item{n}{sample size.}
}
\value{
Unbiased estimate of squared variance \eqn{\mu_2^2}{\mu[2]^2}, where
  \eqn{\mu_2}{\mu[2]} is a variance.
}
\description{
Calculate unbiased estimates of central moments and their powers and
products.
}
\examples{
n <- 10
smp <- rgamma(n, shape = 3)
m <- mean(smp)
for (j in 2:4) {
  m <- c(m, mean((smp - m[1])^j))
}
uM2pow2(m[2], m[4], n)
}
\seealso{
Other unbiased estimates (one-sample): 
\code{\link{uM2}()},
\code{\link{uM2M3}()},
\code{\link{uM2M4}()},
\code{\link{uM2pow3}()},
\code{\link{uM3}()},
\code{\link{uM3pow2}()},
\code{\link{uM4}()},
\code{\link{uM5}()},
\code{\link{uM6}()}
}
\concept{unbiased estimates (one-sample)}
