#' Toy Dataset For Illustration
#'
#' This data set is provided for the purposes of illustrating the use of
#' the software. 
#' 
#' 
#' @usage data(variantData)
#'
#' @format variantData is a data.frame containing 30,000 participants The
#'   data.frame contains 10 columns, 
#'   \describe{
#'   \item{ID}{A unique patient identifier.}
#'   \item{X1}{A dichotomous baseline covariate; generated from B(0.5).}
#'   \item{X2}{A continuous baseline covariates; generated from N(45,10^2).}
#'   \item{E}{The entry time into the study.}
#'   \item{A}{The indicator of vaccination at entry
#'            (1 = vaccinated at entry; 0 = not vaccinated)}
#'   \item{U}{The minimum of: time to infection, 
#'            time to refusing study vaccine after unblinding
#'            (placebo participants only), or censoring 
#'            (due to loss to followup or administrative censoring).}
#'   \item{Delta}{Infection-variant category indicator, where
#'     -1 indicates a placebo participant that was unblinded and refused study 
#'     vaccine; 0 indicates censoring; and
#'     = ve indicates a participant infected with variant ve (ve = 1, ..., nV).} 
#'   \item{R}{The minimum of: time to unblinding, time to infection, or
#'     time to censoring.}
#'   \item{Gamma}{Indicator of the R dynamic, where 1 indicates that R is the
#'     time to unblinding and 0 indicates that R is either the time to infection
#'     or the time to censoring.}
#'   \item{Psi}{Indicator of whether a placebo subject received study vaccine, 
#'     where 1
#'     indicates that a participant that was either assigned to vaccine or was
#'     assigned to placebo, was 
#'     unblinded and decided to get the study vaccine; 0 otherwise.}
#'   }
#'   All time variables are on the scale of weeks.
#'
#' @name variantData
#' @keywords datasets
NULL
