% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildViP.R
\name{BuildViP}
\alias{BuildViP}
\title{Builds a Virtual Population in a Single Step}
\usage{
BuildViP(
  user = NULL,
  pw_HMD = NULL,
  pw_HFD = NULL,
  countrycode,
  cohort = NULL,
  refyear = NULL,
  ncohort,
  ngen,
  mort = TRUE
)
}
\arguments{
\item{user}{User name (e-mail address)}

\item{pw_HMD}{Password Human Mortality Database}

\item{pw_HFD}{Password Human Fertility Database}

\item{countrycode}{Code of country selected}

\item{cohort}{Birth cohort (for virtual population based on cohort data)}

\item{refyear}{Reference year (for virtual population based on period data)}

\item{ncohort}{Size of initial cohort}

\item{ngen}{Number of generations}

\item{mort}{Presence or absence of mortality (optional). Default: mortality is present (mort=TRUE). If mortality is absent, mort=FALSE.}
}
\value{
dLH Dataframe with virtual population (one row per individual) (See description of dLH object).
}
\description{
Builds a virtual population from mortality and fertility rates retrieved from the Human Mortality Database (HMD) and the Human Fertility Database (HFD) in a single step.
}
\examples{
## Registration is required to be able to download data from the HMD and HFD
## HMD: https://www.mortality.org
## HFD: https://www.humanfertility.org
\dontrun{
# Period data
dLH <- BuildViP(user,pw_HMD,pw_HFD,
                    countrycode="USA",
                    refyear=2021,
                    ncohort=1000,
                    ngen=4)
# Cohort data
dLHc <- BuildViP(user,pw_HMD,pw_HFD,
                    countrycode="USA",
                    cohort=1964,
                    ncohort=1000,
                    ngen=4)
}
}
