% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_SS.R
\name{WRSS}
\alias{WRSS}
\title{Compute the sample size for standard win ratio test}
\usage{
WRSS(xi, bparam, q = 0.5, alpha = 0.05, side = 2, power = 0.8)
}
\arguments{
\item{xi}{A bivariate vector of hypothesized component-wise (treatment-to-control) log-hazard
ratios under the Gumbel--Hougaard copula model described in \code{\link{base}}.}

\item{bparam}{A list containing baseline parameters \code{zeta2} for \eqn{\zeta_0^2}
and \code{delta} for \eqn{\boldsymbol\delta_0}; Can directly use the output of \link{base}.}

\item{q}{Proportion of patients assigned to treatment.}

\item{alpha}{Type I error rate.}

\item{side}{2-sided or 1-sided test.}

\item{power}{Target power.}
}
\value{
A list containing \code{n}, the computed sample size.
}
\description{
Compute the sample size for standard win ratio test.
}
\examples{
# The following is not run in package checking to save time.
\dontrun{
## load the package and pilot dataset
library(WR)
head(hfaction_cpx9)
dat<-hfaction_cpx9
## subset to control group
pilot<-dat[dat$trt_ab==0,]

## get the data ready for gumbel.est()
id<-pilot$patid
## convert time from month to year
time<-pilot$time/12
status<-pilot$status
## compute the baseline parameters for the Gumbel--Hougaard
## copula for death and hospitalization
gum<-gumbel.est(id, time, status)

## get the baseline parameters
lambda_D<-gum$lambda_D
lambda_H<-gum$lambda_H
kappa<-gum$kappa
## set up design parameters and use base()
## to calculate bparam for WRSS()
# max follow-up 4 years
tau<-4
# 3 years of initial accrual
tau_b<-3
# loss to follow-up rate
lambda_L=0.05
# compute the baseline parameters
bparam<-base(lambda_D,lambda_H,kappa,tau_b,tau,lambda_L)
bparam

## sample size with power=0.8 under hazard ratios
## 0.9 and 0.8 for death and hospitalization, respectively.
WRSS(xi=log(c(0.9,0.8)),bparam=bparam,q=0.5,alpha=0.05,
    power=0.8)$n
## sample size under the same set-up but with power 0.9
WRSS(xi=log(c(0.9,0.8)),bparam=bparam,q=0.5,alpha=0.05,
    power=0.9)$n
}
}
\references{
Mao, L., Kim, K. and Miao, X. (2021). Sample size formula for general win ratio analysis.
Biometrics, https://doi.org/10.1111/biom.13501.
}
\seealso{
\code{\link{gumbel.est}}, \code{\link{base}}
}
\keyword{WRSS}
