#' @docType package
#' @name Wats-package
#' @aliases Wats
#'
#' @title Wrap Around Time Series graphics
#'
#' @description Wrap-around Time Series (WATS) Plots for Interrupted Time Series Designs with Seasonal Patterns
#'
#' @note The release version is available through
#' [CRAN](https://cran.r-project.org/package=Wats) by
#' running `install.packages('Wats')`.
#' The most recent development version is available through
#' [GitHub](https://github.com/OuhscBbmc/Wats) by running
#' `remotes::install_github("OuhscBbmc/Wats")`.
#' (make sure [remotes](https://cran.r-project.org/package=remotes) is already installed).
#' If you're having trouble with the package, please install the development version.
#' If this doesn't solve your problem,
#' please create an [issue](https://github.com/OuhscBbmc/Wats/issues),
#' or email Will.
#'
#' **Funding**
#' Continued development and maintenance of this package supported by the
#' Oklahoma Shared Clinical and Translational Resources ([OSCTR](https://osctr.ouhsc.edu/),
#' U54GM104938) with an Institutional Development Award (IDeA) from NIGMS.
#' The content is solely the responsibility of the authors and does not necessarily represent
#' the official views of the National Institutes of Health.
#'
#' @author
#' [William Howard Beasley](http://scholar.google.com/citations?user=ffsJTC0AAAAJ)
#' --Associate Professor of Research,
#' [University of Oklahoma Health Sciences Center](https://ouhsc.edu/bbmc/team/),
#' [Dept of Pediatrics](https://medicine.ouhsc.edu/academic-departments/pediatrics),
#' Biomedical and Behavioral Methodology Core ([BBMC](http://ouhsc.edu/bbmc/))
#'
#' [Joseph Lee Rodgers](https://www.vanderbilt.edu/psychological_sciences/bio/joe-rodgers)
#' --Director, Quantitative Methods, Department of Psychology and Human Development,
#' Peabody College, 230 Appleton Pl #552, Hobbs 202C,
#' Vanderbilt University, Nashville, TN 37203.
#'
#' [Matthew Schuelke](https://www.slu.edu/medicine/health-and-clinical-outcomes-research/faculty/schuelke-matt.php)
#' --Senior Statistician, Office of the Vice President for Research
#' Saint Louis University
#'
#' @references
#' Rodgers, J.L., Beasley, W.H., and Schuelke, M. (2014).
#' [Graphical Data Analysis on the Circle:  Wrap-around Time Series Plots for (Interrupted)
#' Time Series Designs.](https://www.tandfonline.com/doi/abs/10.1080/00273171.2014.946589)
#' *Multivariate Behavioral Research*.
#'
#' Rodgers, J.L., St. John, C. A. & Coleman R. (2005).
#' [Did Fertility Go Up after the Oklahoma City Bombing?  An Analysis of Births in
#' Metropolitan Counties in Oklahoma, 1990-1999.](https://pubmed.ncbi.nlm.nih.gov/16463916/)
#' *Demography, 42*, 675-692.
#'
#' @keywords package
NULL
