% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibullFit.R
\name{weibullFit}
\alias{weibullFit}
\title{Weibull-fitting function}
\usage{
weibullFit(dataFrame, primaryGroup = "parcela",
  secondaryGroup = "idadearred", restrValue, pValue = "dap",
  leftTrunc = 5, folder = NA, limit = 1e+05,
  selectedFunctions = NULL, amp = 2, pmaxIT = 20, verbose = FALSE)
}
\arguments{
\item{dataFrame}{the input data frame containing the independent, continuous variable.}

\item{primaryGroup}{the name(String) of the primary grouping column of the data frame.}

\item{secondaryGroup}{the name(String) of the secondary grouping column of the data frame.}

\item{restrValue}{the restriction value choosen to be applied to the secondary group column.}

\item{pValue}{the name(String) of the independent, continuos variable to be analyzed.}

\item{leftTrunc}{An integer, defining the value for the weibull's function truncation.}

\item{folder}{the pathname of the folder where the plots will be saved.}

\item{limit}{A positive integer determining the maximum number of rows from the data frame (grouped by the primary group column) to be analyzed.}

\item{selectedFunctions}{A character vector determining which weibull function to be applied. Can be any of the following: w2, w2te, w2td, w2tetd, w3, w3te, w3td, w3tetd}

\item{amp}{The continuous variable class width to be accounted for the calculations.}

\item{pmaxIT}{A positive integer, the maximum number of iterations used by the algorithm to try to get the weibull function parameters, for each primary group.}

\item{verbose}{Logical, determines if the function prints more detailed results on the console.}
}
\value{
A data frame object containing the best results for shape, location and scale parameters.
}
\description{
This functions calculates the shape, scale and location parameters for the weibull distribution to the input data and save the plots.
}
\details{
This function first extracts a subset of the input data frame using the restrValue parameter applied
         to the secondary group column. Then, it calculates the weibull function scale, shape and location parameters
         using the maximum-likelyhood method. Finally, it plots the results (as .wmf, .csv and .jpeg) inside the folder
         given by the Folder parameter.
}
\examples{
functions <- c("w2", "w3")
best <- weibullFit(restrValue = 60, dataFrame = TreesDBH,
selectedFunctions = functions, amp = 2, pmaxIT = 1, limit = 1)


}
