% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balci2019.R
\name{balci2019}
\alias{balci2019}
\title{Peak individual trial analysis using moving average}
\usage{
balci2019(tasa_norm, bins)
}
\arguments{
\item{tasa_norm, }{numeric, normalized response rate}

\item{bins, }{numeric}
}
\value{
a list with
params: a numeric vector with start, stop, spread and argmax (the bin at which response rate is max)
mov_av: the moving average
}
\description{
Peak individual trial analysis using moving average
}
\details{
Based on Balci et al 2010
}
\examples{
data("r_times")
# binarize r_times to create response rate at 2 sec bins
bins <- get_bins(r_times, 0, 180, 2)
bin_res <- 6
tasa <- f_table(bins, 0, 180, bin_res)
tasa_norm <- tasa$prop / max(tasa$prop)
bins <- tasa$bins
balci_ind <- balci2019(tasa_norm, bins)

plot(bins, tasa_norm, xlab = "6 sec bins", )
lines(bins, balci_ind$mov_av, col = "blue", lwd = 2)
abline(v = balci_ind$params[c(1, 2, 4)], lwd = c(1, 1, 2), col = c(1, 1, "red4"))
}
