test_that("diagnostics and plotting", {
  fit <- readRDS('fit.RDS')
  sp <- extract_sampler_params(fit)
  expect_is(sp,  'data.frame')
  plot_sampler_params(fit, TRUE)
  pairs_admb(fit)
  pairs_admb(fit, pars=1:3, order='slow')
  pairs_admb(fit, pars=1:3, order='fast')
  pairs_admb(fit, pars=c('a', 'lp__', 'b'), add.monitor=FALSE)
  expect_warning(pairs_admb(fit, pars=c('a', 'b', 'c')), 'Some par names did not match')
  expect_error(pairs_admb(fit, pars=c('a')), 'only meaningful for >1 parameter')
  pairs_admb(fit, add.mle=FALSE)
  pairs_admb(fit, add.mle=FALSE, diag='hist')
  pairs_admb(fit, add.mle=FALSE, diag='acf')
  expect_error(pairs_admb(fit, add.mle=FALSE, diag='bad'), 'should be one of')
  plot_marginals(fit)
  plot_marginals(fit, add.monitor=FALSE)
  plot_marginals(fit, add.mle=FALSE)
  x <- plot_uncertainties(fit, plot=FALSE)
})
