% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/af_colours.R
\name{af_colours}
\alias{af_colours}
\title{Analysis Function colour palette function}
\usage{
af_colours(
  type = c("categorical", "duo", "sequential", "focus"),
  colour_format = "hex",
  n = 6
)
}
\arguments{
\item{type}{Name of required palette. Choices are:
\code{categorical}, \code{duo},  \code{sequential},
\code{focus}}

\item{colour_format}{Type of colour code to return. Choices are:
\code{hex}, \code{rgb}
If omitted, returns hex code}

\item{n}{Number of colours to return for categorical palette type (max 6).
If omitted, uses all colours.}
}
\value{
A vector of colour codes
}
\description{
Generate a colour palette based on the selected chart and colour_format type (hex/rgb).
}
\examples{
data <- data.frame(x = c(1,2),
                   y = c(1,2),
                   z = c("a","b")
        )
ggplot2::ggplot(data, ggplot2::aes(x = x, y = y, colour = z)) +
ggplot2::geom_point() +
ggplot2::scale_colour_manual(values = af_colours("duo"))
}
\keyword{colours}
