% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ags_dist.R
\name{ags_dist}
\alias{ags_dist}
\title{Defines a distance metric for the AGS}
\usage{
ags_dist(x, y, landw = 10^6, kreisw = 10^3, gemw = 1, ceiling = 99999999)
}
\arguments{
\item{x, y}{vectors of AGS values}

\item{landw}{weight of the Bundesland (Land) integers}

\item{kreisw}{weight of the Kreis (district) integers}

\item{gemw}{weight of the Gemeinde (municipality) integers}

\item{ceiling}{truncate all distances at this value}
}
\value{
A numerical vector.
}
\description{
Defines a distance metric for the AGS
}
\details{
The distance metric is defined as

abs(x[1:2]- y[1:2])*landw  +
abs(x[3:5]- y[3:5])*kreisw +
abs(x[6:8]- y[6:8])*gemw,

where z[a:b] means all digits between a and b for integer z.

With the default weights, this sum is the absolute difference
between x and y.
}
\examples{
ags_dist(14053,14059)

}
