% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_ags.R
\name{format_ags}
\alias{format_ags}
\title{Formats AGS with a Leading Zero}
\usage{
format_ags(ags, type, verbose = FALSE)
}
\arguments{
\item{ags}{Input vector that will be coerced into an integer
vector. Factor vectors are first coerced to a character vector
and then to an integer vector.}

\item{type}{Type of AGS supplied as \code{ags}. Three options are available:
\itemize{
\item \code{land}: Bundesland AGS (Bundeslandschlüssel, 2 digits)
\item \code{district}: District AGS (Kreisschlüssel, 5 digits)
\item \code{municipality}: Municipality AGS (Gemeindeschlüssel, 8 digits)
}

The abbreviations \code{l}, \code{d}, and \code{m} are also accepted.}

\item{verbose}{If \code{TRUE} the function outputs additional information.}
}
\value{
A character vector.
}
\description{
Formats AGS with a Leading Zero
}
\examples{
format_ags(c(1,14), type="land")
format_ags(c(1002,14612), type="district")
format_ags(c(01002000,14612000), type="municipality")

}
