% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_optimaldecision.R
\name{CalOptimalDecision}
\alias{CalOptimalDecision}
\title{Calculate optimal decision & utility}
\usage{
CalOptimalDecision(
  data,
  mcmc.re,
  c0.ls,
  c1.ls,
  dmf = NULL,
  rho = 0,
  burnin = 0,
  out.length = 500,
  ZX = NULL,
  size = 5,
  include.utility.diff.mcmc = FALSE
)
}
\arguments{
\item{data}{A \code{data.frame} or \code{matrix} of which columns consists of pre-treatment covariates, a binary treatment (Z), an ordinal decision (D), and an outcome variable (Y). The column names of the latter three should be specified as "Z", "D", and "Y" respectively.}

\item{mcmc.re}{A \code{mcmc} object generated by \code{AiEvalmcmc()} function.}

\item{c0.ls}{The list of cost of an outcome. See Section 3.7 for more details.}

\item{c1.ls}{The list of cost of an unnecessarily harsh decision. See Section 3.7 for more details.}

\item{dmf}{A numeric vector of binary DMF recommendations. If \code{null}, use judge's decisions (0 if the decision is 0 and 1 o.w; e.g., signature or cash bond).}

\item{rho}{A sensitivity parameter. The default is  \code{0} which implies the unconfoundedness assumption (Assumption 4).}

\item{burnin}{A proportion of burnin for the Markov chain. The default is \code{0}.}

\item{out.length}{An integer to specify the progress on the screen. Every \code{out.length}-th iteration is printed on the screen. The default is \code{500}.}

\item{ZX}{The data matrix for interaction terms. The default is the interaction between Z and all of the pre-treatment covariates (X).}

\item{size}{The number of parallel computing. The default is \code{5}.}

\item{include.utility.diff.mcmc}{A logical argument specifying whether to save \code{Utility.diff.control.mcmc} and \code{Utility.diff.treated.mcmc} for Figure S17. The default is \code{FALSE}.}
}
\value{
A \code{data.frame} of (1) the probability that the optimal decision for each observation being d in (0,1,...,k), (2) expected utility of binary version of judge's decision (g_d), (3) expected utility of binary DMF recommendation, and (4) the difference between (2) and (3). If \code{include.utility.diff.mcmc = TRUE}, returns a list of such \code{data.frame} and a \code{data.frame} that includes the result for mean and quantile of \code{Utility.diff.control.mcmc} and \code{Utility.diff.treated.mcmc} across mcmc samples.
}
\description{
(1) Calculate optimal decision for each observation given each of c0 (cost of an outcome) and c1 (cost of an unnecessarily harsh decision) from the lists.
(2) Calculate difference in the expected utility between binary version of judge's decisions and DMF recommendations given each of c0 (cost of an outcome) and c1 (cost of an unnecessarily harsh decision) from the lists.
}
\examples{
\donttest{
data(synth)
sample_mcmc <- AiEvalmcmc(data = synth, n.mcmc = 10)
sample_optd <- CalOptimalDecision(
  data = synth, mcmc.re = sample_mcmc,
  c0.ls = seq(0, 5, 1), c1.ls = seq(0, 5, 1),
  size = 1
) # adjust the size
}

}
