% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_principal.R
\name{CalPS}
\alias{CalPS}
\title{Calculate the proportion of principal strata (R)}
\usage{
CalPS(
  p.r.mcmc,
  name.group = c("Overall", "Female", "Male", "Non-white\\nMale", "White\\nMale")
)
}
\arguments{
\item{p.r.mcmc}{P.R.mcmc array generated from \code{CalAPCE} or \code{CalAPCEparallel}.}

\item{name.group}{A character vector including the labels of five subgroups.}
}
\value{
A \code{data.frame} of the proportion of each principal stratum.
}
\description{
Calculate the proportion of each principal stratum (R).
}
\examples{
\donttest{
data(synth)
sample_mcmc <- AiEvalmcmc(data = synth, n.mcmc = 10)
subgroup_synth <- list(
  1:nrow(synth), which(synth$Sex == 0), which(synth$Sex == 1),
  which(synth$Sex == 1 & synth$White == 0), which(synth$Sex == 1 & synth$White == 1)
)
sample_apce <- CalAPCE(
  data = synth, mcmc.re = sample_mcmc,
  subgroup = subgroup_synth
)
CalPS(sample_apce[["P.R.mcmc"]])
}

}
