% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcalendar.R
\name{rcalendar}
\alias{rcalendar}
\title{Create a recurring calendar}
\usage{
rcalendar(...)
}
\arguments{
\item{...}{\verb{[rholidays]}

One or more holidays created from \code{\link[=rholiday]{rholiday()}} or \verb{hol_*()}.}
}
\description{
\code{rcalendar()} creates a calendar filled with holidays created from one of the
existing \verb{hol_*()} holidays (such as \code{\link[=hol_christmas]{hol_christmas()}}) or from a manually
generated holiday created using \code{\link[=rholiday]{rholiday()}}. That calendar can then be used
as an rschedule with any other \verb{alma_*()} function (like \code{\link[=alma_in]{alma_in()}}), or
with one of the specialized calendar functions, like \code{\link[=cal_match]{cal_match()}} or
\code{\link[=cal_events]{cal_events()}}.
}
\examples{
on_earth_day <- yearly() \%>\%
  recur_on_month_of_year("April") \%>\%
  recur_on_day_of_month(22) \%>\%
  rholiday("Earth Day")

cal <- rcalendar(
  hol_christmas(),
  on_earth_day,
  hol_us_independence_day()
)

cal

cal_events(cal, year = 2020:2022)

# Lookup holiday name based on date, if it exists
cal_match(c("2021-12-25", "2021-12-26"), cal)

# Find next holiday
alma_next("2021-12-26", cal)
}
