% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_names.R
\name{check_names}
\alias{check_names}
\title{Amanida harmonization}
\usage{
check_names(data)
}
\arguments{
\item{data}{data imported using \code{amanida_read} function}
}
\value{
tibble table with data imported with PubChem ID retrieved
}
\description{
\code{check_names} check the names to harmonize them to a common nomenclature. Valid names are:
chemical name, InChI, InChIKey and SMILES.
}
\details{
Note that \code{check_names} depends on \code{webchem}package and it slows down the process.

Formats compatible are \code{amanida_read} output
}
\examples{
\dontrun{
coln <-  c("Compound Name", "P-value", "Fold-change", "N total", "References")
input_file <- getsampleDB()
datafile <- amanida_read(input_file, mode = "quan", coln, separator=";")

data_checked <- check_names(datafile) 
}

}
