#' Plots a plot of class 'analyzerPlot'
#'
#' This function plots the plot generated by the library \code{analyzer}
#'
#' @param x a plot of class \code{analyzerPlot}
#' @param ... extra arguments if required
#'
#' @return Displays the plot
#'
#' @examples
#' # creating the plot
#' p <- plottr(mtcars)
#' plot(p$mpg)
#'
#' @export
plot.analyzerPlot <- function(x,
                              ...) {
  # removing the 'analyzerPlot' class from 'x' to prevent it from recurssion
  xclass <- class(x)
  xclass <- setdiff(xclass, "analyzerPlot")
  class(x) <- xclass
  # clearing the canvas and drawing the plot
  grid.newpage()
  grid.draw(x)
}


#' Method for print generic
#'
#' This function plots the plot generated by the library \code{analyzer}
#'
#' @param x a plot of class \code{analyzerPlot}
#' @param ... other parameters
#'
#' @return Displays the plot
#'
#' @examples
#' # creating the plot
#' p <- plottr(mtcars$mpg)
#' p$x
#'
#' @export
print.analyzerPlot <- function(x,
                               ...) {
  plot(x)
}
