% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_analysis.R
\name{andorR_interactive}
\alias{andorR_interactive}
\title{Enter Interactive Analysis Mode}
\usage{
andorR_interactive(tree, sort_by = "BOTH")
}
\arguments{
\item{tree}{The \code{data.tree} object to be analysed.}

\item{sort_by}{A character string indicating how the prioritised questions
should be sorted. Options are:
\itemize{
\item "TRUE" : Sort by the product of the node true_index for all ancestors, which
measures the influence of the question if it is answered TRUE
\item "FALSE" : Sort by the product of the node false_index for all ancestors, which
measures the influence of the question if it is answered FALSE
\item "BOTH" : (Default) Sort by the sum of 'TRUE' and 'FALSE' values which measures
the aggregate influence of the question before the answer is known
}}
}
\value{
The final, updated \code{data.tree} object.
}
\description{
Iteratively prompts the user to answer questions to solve a decision tree.
The function first presents the most impactful unanswered questions. Once the
tree's root is solved, it presents questions that can increase the overall
confidence of the conclusion.
}
\details{
This function provides a command-line interface (CLI) for working with the
tree. It uses the \code{cli} package for formatted output and handles user input
for quitting, saving, printing the tree state, or providing answers to
specific questions (either by number or by name). All tree modifications are
performed by calling the package's existing API functions:
\itemize{
\item \code{set_answer()}
\item \code{update_tree()}
\item \code{get_highest_influence()}
\item \code{get_confidence_boosters()}
}

The following key commands may be used during interactive mode:
\itemize{
\item \strong{h} : Show the help screen
\item \strong{p} : Print the current state of the tree
\item \strong{s} : Save the current state of the tree to an .rds file
\item \strong{q} : Quit (exit interactive mode)
\item \strong{n} : Specify a node to edit by name (case sensitive)
\item \strong{1, 2, ...} : Specify a node to edit from the numbered list
}
}
\examples{
# Load a tree
ethical_tree <- load_tree_df(ethical)

# Start interactive mode
if(interactive()){
  andorR_interactive(ethical_tree)
}

}
