% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_tree.R
\name{load_tree_csv_path}
\alias{load_tree_csv_path}
\title{Load a decision tree from a CSV file (Path String Format)}
\usage{
load_tree_csv_path(file_path, delim = "/")
}
\arguments{
\item{file_path}{The path to the .csv file.}

\item{delim}{The character used to separate nodes in the path string.
Defaults to "/".}
}
\value{
A \code{data.tree} object.
}
\description{
Reads a CSV file from a given path and constructs a tree. This
function expects the CSV to define the tree in a path string format, with
each node's hierarchy defined in a column named \code{path}.
}
\examples{

#' # Load data from the `ethical_path.csv` file included with this package
path <- system.file("extdata", "ethical_path.csv", package = "andorR")
ethical_tree <- load_tree_csv_path(path)

# View the tree
print_tree(ethical_tree)

}
\seealso{
\code{\link[=load_tree_df_path]{load_tree_df_path()}} for the underlying constructor function.
}
