% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_apsimx_replace_soil_profile.R
\name{edit_apsimx_replace_soil_profile}
\alias{edit_apsimx_replace_soil_profile}
\title{Edit APSIM-X file with a replaced soil profile}
\usage{
edit_apsimx_replace_soil_profile(
  file = "",
  src.dir = ".",
  wrt.dir = NULL,
  soil.profile = NULL,
  edit.tag = "-edited",
  overwrite = FALSE,
  verbose = TRUE,
  root = NULL
)
}
\arguments{
\item{file}{name of the .apsimx file to be edited}

\item{src.dir}{source directory}

\item{wrt.dir}{writing directory}

\item{soil.profile}{a soil profile object with class \sQuote{soil_profile}}

\item{edit.tag}{default edit tag \sQuote{-edited}}

\item{overwrite}{default FALSE}

\item{verbose}{default TRUE and it will print messages to console}

\item{root}{supply the node position in the case of multiple simulations such as factorials.}
}
\value{
writes a file to disk with the supplied soil profile
}
\description{
Edits an APSIM-X simulation by replacing the soil profile
}
\details{
This function is designed to batch replace the whole soil in an APSIM simulation file.
}
\note{
There is no such thing as a default soil, carefully build the profile for each simulation.
}
\examples{
\donttest{
sp <- apsimx_soil_profile()
extd.dir <- system.file("extdata", package = "apsimx")

## I write to a temp directory but replace as needed
tmp.dir <- tempdir()

edit_apsimx_replace_soil_profile("Maize.apsimx", soil.profile = sp, 
                                  src.dir = extd.dir, wrt.dir = tmp.dir)
inspect_apsimx("Maize-edited.apsimx", src.dir = tmp.dir,
                 node = "Soil")
 }

}
