% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_packages.R
\name{assert_packages_installed}
\alias{assert_packages_installed}
\title{Assert packages are installed}
\usage{
assert_packages_installed(
  x,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{Package name(s) (character vector)}

\item{msg}{A character string containing the error message to display if the
package is not installed}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is installed, otherwise aborts with the
message specified by \code{msg}
}
\description{
Assert that one or more packages are installed.
}
\examples{
try({
assert_packages_installed("stats") # Passes
assert_packages_installed(c("stats", "utils")) # Passes
assert_packages_installed("notapackage123") # Throws Error
})

}
\concept{assert_package}
