% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_config.R
\name{use_config}
\alias{use_config}
\title{Use Config File}
\usage{
use_config(config = "~/.bambooHR_user_config.json", verbose = TRUE)
}
\arguments{
\item{config}{Filepath to the config file.}

\item{verbose}{Print location of config file being used, default = TRUE}
}
\value{
[NULL] invisibly.
}
\description{
Choose a specific configuration file to supply the API key and the company
domain.
}
\details{
In rare circumstances, it may be useful to swap between multiple
configuration files, for example when comparing results on different accounts
possibly with different permissions. In this case a user may set-up two
config files with [config_setup] in different locations (see
[conffile] argument), and swap between them with [use_config]. The chosen
config file will then be used for subsequent API calls, as [use_config] sets
global options and variables in the package environment. Of course,
[config_setup] does all of this too, however [use_config] does not expose
the API key when called.
}
\examples{
\dontrun{
# Setup 2 configuration files
config_setup(apikey = "key", companyname = "Ascent", conffile = "example.json")
config_setup(apikey = "key2", companyname = "Descent", conffile = "example2.json")

# Jump between them
use_config("example.json")
use_config("example2.json")

# Remove them when finished
unlink("example.json")
unlink("example2.json")
}
}
