% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_ncaa_baseball_schedule.R
\name{load_ncaa_baseball_schedule}
\alias{load_ncaa_baseball_schedule}
\title{\strong{Load cleaned NCAA baseball schedule from the baseballr data repo}}
\usage{
load_ncaa_baseball_schedule(
  seasons = most_recent_ncaa_baseball_season(),
  ...,
  dbConnection = NULL,
  tablename = NULL
)
}
\arguments{
\item{seasons}{A vector of 4-digit years associated with given NCAA college baseball seasons. (Min: 2012)}

\item{...}{Additional arguments passed to an underlying function that writes
the season data into a database.}

\item{dbConnection}{A \code{DBIConnection} object, as returned by}

\item{tablename}{The name of the schedule data table within the database}
}
\value{
Returns a tibble
}
\description{
helper that loads multiple seasons from the data repo either into memory
or writes it into a db using some forwarded arguments in the dots
}
\examples{
\donttest{
  try(load_ncaa_baseball_schedule(seasons = 2022))
}
}
